% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_aircrafts.R
\name{read_aircrafts}
\alias{read_aircrafts}
\title{Download aircrafts data from Brazil}
\usage{
read_aircrafts(date = 202001, showProgress = TRUE)
}
\arguments{
\item{date}{Numeric. Date of the data in the format \code{yyyymm}. Defaults to
\code{202001}. To download the data for all months in a year, the user
can pass a 4-digit year input \code{yyyy}.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress.}
}
\value{
A \verb{"data.table" "data.frame"} object. All columns are returned with
\code{class} of type \code{"character"}.
}
\description{
Download data of all aircrafts registered in the Brazilian Aeronautical
Registry (Registro Aeronáutico Brasileiro - RAB), organized by the Brazilian
Civil Aviation Agency (ANAC). A description of all variables included in the
data is available at \url{https://www.gov.br/anac/pt-br/sistemas/rab}.
}
\examples{
\dontrun{ if (interactive()) {
# Read aircrafts data
aircrafts <- read_aircrafts(showProgress = TRUE)

}}
}
\seealso{
Other download flight data: 
\code{\link{read_flights}()}
}
\concept{download flight data}
