% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{weightedChi2P}
\alias{weightedChi2P}
\title{Tail Probability for Chi Square Convolution Random Variable}
\usage{
weightedChi2P(val, w1, w2, d1, d2)
}
\arguments{
\item{val}{observed statistic}

\item{w1}{weight of first chi square rv}

\item{w2}{weight of second chi square rv, assumed positive}

\item{d1}{degrees of freedom of first chi square rv}

\item{d2}{degrees of freedom of second chi square rv}
}
\value{
1 - CDF = P(X > val)
}
\description{
Computes \eqn{P(X > val)} where \eqn{X = w_1 Y + w_2 Z}, where
\eqn{Y} is chi square distributed with \eqn{d_1} degrees of freedom,
\eqn{Z} is chi square distributed with \eqn{d_2} degrees of freedom,
and \eqn{w_1} and \eqn{w_2} are weights with \eqn{w_2} assumed positive.
The probability is computed using numerical integration of the
densities of the two chi square distributions. (Method: trapezoidal rule)
}
\details{
This is used in the large \eqn{P} asymptotics of the permutation test.

Dependencies: None
}
