% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fc_view.R
\name{fc_view}
\alias{fc_view}
\title{fc_view}
\usage{
fc_view(object, what)
}
\arguments{
\item{object}{fc object that we want to access.}

\item{what}{Choose "data" to return the data associated to the flowchart stored in `$data` or "fc" to return the flowchart information stored in `$fc`.}
}
\value{
Returns a tibble. Either `$data` or `$fc`.
}
\description{
This function allows you to return either the data stored in `$data` or the flowchart information stored in `$fc`.
}
\examples{
#Return the data associated to the flowchart
safo |>
 as_fc(label = "Patients assessed for eligibility") |>
 fc_filter(!is.na(group), label = "Randomized", show_exc = TRUE) |>
 fc_view("data")

#Return the flowchart information
safo |>
 as_fc(label = "Patients assessed for eligibility") |>
 fc_filter(!is.na(group), label = "Randomized", show_exc = TRUE) |>
 fc_view("fc")

}
