% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flows.R
\name{domflows}
\alias{domflows}
\title{Dominant Flows Selection}
\usage{
domflows(mat, w, k)
}
\arguments{
\item{mat}{A square matrix of flows.}

\item{w}{A vector of units weigths (sum of incoming flows, sum of outgoing flows...).}

\item{k}{A threshold (see 'Details').}
}
\value{
A boolean matrix of selected flows.
}
\description{
Dominant flows selection.
}
\details{
This function selects which flow (fij or fji) must be kept.
If the ratio weight of destination (wj) / weight of origin (wi) is greater
than k, then fij is selected and fji is not.
This function can perform the second criterion of the Nystuen &
Dacey's dominants flows analysis.\cr
As the output is a boolean matrix, use element-wise multiplication to get flows intensity.
}
\examples{
# Import data
data(nav)
myflows <- prepflows(mat = nav, i = "i", j = "j", fij = "fij")

# Remove the matrix diagonal
diag(myflows) <- 0

# Select the dominant flows (incoming flows criterion)
flowSel <- domflows(mat = myflows, w = colSums(myflows), k = 1)
statmat(mat = myflows * flowSel, output = "none")
}
\references{
J. Nystuen & M. Dacey, 1961, "A Graph Theory Interpretation of Nodal Regions.",
\emph{Papers and Proceedings of the Regional Science Association}, 7:29-42.bt
}
\seealso{
\link{firstflows}, \link{firstflowsg}, \link{plotDomFlows}, \link{plotMapDomFlows}
}

