% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux_quality_qua.R
\name{flux_quality_qua}
\alias{flux_quality_qua}
\title{quality assessment for the slopes estimated by flux_fitting}
\usage{
flux_quality_qua(
  slopes_df,
  conc_col,
  f_fluxid,
  f_slope,
  f_cut,
  f_pvalue,
  f_rsquared,
  f_slope_lm,
  force_discard,
  force_ok,
  force_zero,
  force_lm,
  gfactor_threshold,
  pvalue_threshold,
  rsquared_threshold,
  name_df
)
}
\arguments{
\item{slopes_df}{dataset containing slopes, fluxID, p.value and r.squared}

\item{conc_col}{column with gas concentration}

\item{f_fluxid}{column of ID for each measurement}

\item{f_slope}{column containing the slope of each flux
(as calculated by the \link[fluxible:flux_fitting]{flux_fitting} function)}

\item{f_cut}{column containing the cutting information}

\item{f_pvalue}{column containing the p-value of each flux}

\item{f_rsquared}{column containing the r squared to be used for
the quality assessment}

\item{f_slope_lm}{column containing the linear slope of each flux
(as calculated by the \link[fluxible:flux_fitting]{flux_fitting} function)}

\item{force_discard}{vector of fluxIDs that should be discarded
by the user's decision}

\item{force_ok}{vector of fluxIDs for which the user wants to keep
the calculated slope despite a bad quality flag}

\item{force_zero}{vector of fluxIDs that should be replaced by zero by
the user's decision}

\item{force_lm}{vector of fluxIDs for which the linear slope should be used
by the user's decision}

\item{gfactor_threshold}{threshold for the g-factor. Defines a window
with its opposite outside which the flux will be flagged \code{discard}.}

\item{pvalue_threshold}{threshold of p-value below which the change
of gas concentration over time is considered not significant (user decided)}

\item{rsquared_threshold}{threshold of r squared value below which
the linear model is considered an unsatisfactory fit}

\item{name_df}{name of slopes_df (used for error message)}
}
\value{
same dataframe with added flag and corrected slopes columns
}
\description{
indicates if fluxes should be discarded or replaced by 0
according to parameters set by user.
flux_quality_lm is for the model of the lm family.
flux_quality_exp is for the exponential model.
}
