% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.R
\name{make.stability}
\alias{make.stability}
\title{making network stability}
\usage{
make.stability(val.mat, biomasses, losses, efficiencies, growth.rate,
  losses.scale = NULL, bioms.prefs = TRUE, bioms.losses = TRUE,
  ef.level = "prey", interval = c(1e-12, 1), ...)
}
\arguments{
\item{val.mat}{A matrix describing fluxes between species (usually a result of \code{\link[fluxweb]{fluxing}} function).}

\item{biomasses}{A vector of species biomasses.}

\item{losses}{A vector or an array of species energy losses (excluding predation).}

\item{efficiencies}{A vector or an array of conversion efficiencies of species in the adjacency matrix. These values describe the proportion of consumed energy that is converted to biomass of the consumer.}

\item{growth.rate}{A vector defining growth rate of basal species.}

\item{losses.scale}{Defines a Column from \code{losses} on which scalar multiplication will be tested. (default \code{NULL} if the value is independent of losses).}

\item{bioms.prefs}{Logical, if \code{TRUE} (default) preferences are scaled accordingly to species biomasses.}

\item{bioms.losses}{Logical, if \code{TRUE} (default) losses are scaled with biomass.}

\item{ef.level}{Set to \code{"prey"} if efficiencies are defined by prey, \code{"pred"} if they are a property of the predator.}

\item{interval}{Search interval for returned value.}

\item{...}{Optional parameters for function \code{\link[stats]{uniroot}}}
}
\value{
A list from \code{\link[stats]{uniroot}} function.
}
\description{
Find the smallest scalar multiplying a variable from losses insuring system stability
}
\details{
The function assumes a monotonous increase of stability with multiplication by a scalar value. Solution is estimated from the \code{\link[stats]{uniroot}} function, and stability using the \code{\link[fluxweb]{fluxing}} function
Thus, accordingly to \code{\link[stats]{uniroot}} solving criteria, if stability values at the two extremum parts of the interval are of same sign, an error is raised.

Behavior of the multiplicative term depends on the type of losses:
\itemize{
\item{\code{losses.scale = NULL} and \code{is.vector(losses)}:} multiplication will be applied to the \code{losses} vector.
\item{\code{losses.scale = NULL} and \code{is.matrix(losses)}:} multiplication will be independent of any columns from \code{losses}.
\item{\code{losses.scale = FALSE} :} value used for multiplication always independent of losses.
\item{other values:} should refer to an element of losses.
}
}
\examples{

losses = 0.15 * groups.level$bodymasses^(-0.25)

# growth rates of basal sppecies
growth.rates = rep(NA, dim(groups.level$mat)[1])
growth.rates[colSums(groups.level$mat) == 0] = 0.5

val.mat = fluxing(groups.level$mat, 
                  groups.level$biomasses, 
                  losses, 
                  groups.level$efficiencies, 
                  bioms.pref = TRUE, 
                  ef.level = "pred")
make.stability(val.mat, 
               groups.level$biomasses, 
               losses, 
               groups.level$efficiencies, 
               growth.rates, 
               ef.level = "pred")

}
\seealso{
\code{\link[stats]{uniroot}} for root estimate and \code{\link[fluxweb]{stability.value}} for assessing system stability.
}
