% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar-classes.R
\name{JointCalendar}
\alias{JointCalendar}
\title{Joint calendars}
\usage{
JointCalendar(calendars, rule = all)
}
\arguments{
\item{calendars}{a list of at least one \code{Calendar()} objects}

\item{rule}{either \code{all} or \code{any} corresponding to a date being good if
it is good in all or any of the calendars supplied.}
}
\value{
an object of class \code{JointCalendar} when using \code{JointCalendar()}
}
\description{
Sometimes the calendar governing a financial contract is defined by multiple
single locales. These joint calendars are represented by the \code{JointCalendar}
class.
}
\examples{
JointCalendar(list(AUSYCalendar(), AUMECalendar()), all)
JointCalendar(list(AUSYCalendar(), AUMECalendar()), any)
}
\seealso{
Other calendar classes: \code{\link{Calendar}}
}
