% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addconst.R
\name{addconst}
\alias{addconst}
\title{Additive Constant Function for Classical Multidimensional Scaling}
\usage{
addconst(delta, faster = FALSE, error.check = FALSE)
}
\arguments{
\item{delta}{an n by n square symmetric hollow matrix containing (non-negative) dissimilarities.}

\item{faster}{logical indicating faster but less precise procedure}

\item{error.check}{extensive check validity input (data) parameters (default = FALSE).}
}
\value{
additive constant
}
\description{
\code{addconst} returns the smallest additive constant which,
added to the dissimilarities, makes the data true Euclidean distances.
Note: NA's are not allowed.
}
\examples{
delta <- as.matrix( eurodist )
ac <- addconst( delta, faster = TRUE, error.check = TRUE )
print( ac )

}
\references{
Cailliez (1983)
}
\author{
Frank M.T.A. Busing
}
