% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fem.R
\name{fm_fem}
\alias{fm_fem}
\alias{fm_fem.fm_mesh_1d}
\alias{fm_fem.fm_mesh_2d}
\alias{fm_fem.fm_tensor}
\alias{fm_fem.fm_mesh_3d}
\title{Compute finite element matrices}
\usage{
fm_fem(mesh, order = 2, ...)

\method{fm_fem}{fm_mesh_1d}(mesh, order = 2, ...)

\method{fm_fem}{fm_mesh_2d}(mesh, order = 2, aniso = NULL, ...)

\method{fm_fem}{fm_tensor}(mesh, order = 2, ...)

\method{fm_fem}{fm_mesh_3d}(mesh, order = 2, ...)
}
\arguments{
\item{mesh}{\code{fm_mesh_1d} or other supported mesh class object}

\item{order}{integer}

\item{...}{Currently unused}

\item{aniso}{If non-NULL, a \code{list(gamma, v)}. Calculates anisotropic
structure matrices (in addition to the regular) for \eqn{\gamma}{gamma} and
\eqn{v}{v} for an anisotropic operator \eqn{\nabla\cdot H \nabla}{div H
  grad}, where \eqn{H=\gamma I + v v^\top}{H = gamma I + v v'}. Currently
(2023-08-05) the fields need to be given per vertex.}
}
\value{
\code{fm_fem.fm_mesh_1d}: A list with elements \code{c0}, \code{c1}, \code{g1}, \code{g2}.
When \code{mesh$degree == 2}, also \code{g01}, \code{g02}, and \code{g12}.

\code{fm_fem.fm_mesh_2d}: A list with elements \code{c0}, \code{c1}, \code{g1}, \code{va},
\code{ta}, and more if \code{order > 1}. When \code{aniso} is non-NULL, also \code{g1aniso}
matrices, etc.

\code{fm_fem.fm_tensor}: A list with elements \code{cc}, \code{g1}, \code{g2}.

\code{fm_fem.fm_mesh_3d}: A list with elements \code{c0}, \code{c1}, \code{g1}, \code{g2},
\code{va}, \code{ta}, and more if \code{order > 2}.
}
\description{
(...)
}
\examples{
str(fm_fem(fmexample$mesh))

}
