% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pricing.R
\name{fmpc_price_current}
\alias{fmpc_price_current}
\title{Current price}
\usage{
fmpc_price_current(symbols = c("AAPL"))
}
\arguments{
\item{symbols}{one or more symbols from the FMP available list that can be
found using \code{\link{fmpc_symbols_by_market}}. A valid API token must be
set in order to enable functionality. See documentation for setting a token
under \code{\link{fmpc_set_token}}.}
}
\value{
data frame of current price details
}
\description{
Last traded price with additional price metrics such as 50D and 200D avg
price, volume, shares outstanding, and more. This does NOT include a quote,
such as bid/ask detail.
}
\examples{


\dontrun{

# Setting API key to 'demo' allows for AAPL only
fmpc_set_token()
fmpc_price_current('AAPL')

# For multiple symbols, set a valid API Token
fmpc_set_token('FMPAPIKEY')
fmpc_price_current(c('AAPL', 'MSFT', 'TSLA', 'SPY', 'BTCUSD', 'JPYUSD', '^SP500TR'))

}


}
