% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R
\name{fold_.data.frame}
\alias{fold_.data.frame}
\title{Fold a Data.frame, Standard Evaluation}
\usage{
\method{fold_}{data.frame}(x, groups = c(character(0), attr(x, "groups")),
  meta = obj_attr(x), simplify = TRUE, sort = TRUE, tol = 10, ...)
}
\arguments{
\item{x}{data.frame}

\item{groups}{a vector of column names whose interaction makes records unique. Included in result but not stacked. See also \code{\link{fold.grouped_df}}.  Alternatively, pre-specify as a groups attribute.}

\item{meta}{a list of formulas in the form object ~ attribute. Pass something with length 0 to suppress guessing.}

\item{simplify}{set to NA any groups values that do not help distinguish values, and remove resulting duplicate records}

\item{sort}{whether to sort the result}

\item{tol}{maximum number of categories for guessing whether to encode metadata; encoding will always be attempted if metadata (attr) or its referent (obj) is a factor}

\item{...}{ignored arguments}
}
\value{
folded data.frame with columns VARIABLE, META, VALUE and any supplied grouping items.
}
\description{
Folds a data.frame using standard evaluation. See also \code{\link{fold.data.frame}}.
}
\examples{
library(magrittr)
library(dplyr)
data(events)
x <- events
x \%<>\% filter(CMT == 2) \%>\% select(-EVID,-CMT,-AMT)
x \%>\% fold_(groups = c('USUBJID','TIME'))
x \%>\% fold_(groups = c('USUBJID','TIME'), meta = list(DV ~ BLQ, DV ~ LLOQ))
}
\seealso{
\code{\link{obj_attr.data.frame}} 
\code{\link{fold.data.frame}} 
\code{\link{fold_}}
}
