% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isotopes.R
\docType{data}
\name{ngrip2004}
\alias{ngrip2004}
\title{North GRIP}
\format{
A \code{\link{data.frame}} with 2 variables:
\describe{
\item{age}{Calendar age (years before 2000 AD).}
\item{delta}{\eqn{\delta^{18}O}{\delta18O} (per mil).}
}
}
\source{
\url{https://www.ncei.noaa.gov/access/paleo-search/study/2481}
}
\usage{
ngrip2004
}
\description{
50-year averaged oxygen isotope data from the North Greenland Ice Core
Project.
}
\examples{
plot(
  x = ngrip2004$age / 1000,
  y = ngrip2004$delta,
  type = "l",
  xlim = c(120, 0),
  xlab = "kilo year b2k",
  ylab = expression(delta^{18}*"O")
)
}
\references{
North Greenland Ice Core Project members (2004). High-resolution record of
Northern Hemisphere climate extending into the last interglacial period.
\emph{Nature}, 431(7005), 147-151. \doi{10.1038/nature02805}
}
\seealso{
Other palaeoenvironment data: 
\code{\link{epica2008}},
\code{\link{law2006}},
\code{\link{lisiecki2005}},
\code{\link{spratt2016}}

Other isotopic data: 
\code{\link{lisiecki2005}},
\code{\link{nydal1996}},
\code{\link{spratt2016}}
}
\concept{isotopic data}
\concept{palaeoenvironment data}
\keyword{datasets}
