% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_ipsum_mplus.R
\name{theme_ipsum_mplus_c1}
\alias{theme_ipsum_mplus_c1}
\title{ggplot2 theme based on M+ C Type1 fonts.}
\usage{
theme_ipsum_mplus_c1(base_family = mplus.fontfamilies$`1c`,
  plot_title_family = mplus.fontfamilies$`1c-bold`,
  subtitle_family = mplus.fontfamilies$`1c-medium`,
  strip_text_family = mplus.fontfamilies$`1c-regular`,
  caption_family = mplus.fontfamilies$`1c-light`,
  axis_title_family = mplus.fontfamilies$`1c-light`, ...)
}
\arguments{
\item{base_family}{base font family and size}

\item{plot_title_family}{plot title family, face, size and margi}

\item{subtitle_family}{plot subtitle family, face and size}

\item{strip_text_family}{facet label font family, face and size}

\item{caption_family}{plot caption family, face, size and margin}

\item{axis_title_family}{axis title font family, face and size}

\item{...}{Arguments passed on to \code{hrbrthemes::theme_ipsum}
\describe{
  \item{base_size}{base font family and size}
  \item{plot_title_face}{plot title family, face, size and margi}
  \item{plot_title_size}{plot title family, face, size and margi}
  \item{plot_title_margin}{plot title family, face, size and margi}
  \item{subtitle_family}{plot subtitle family, face and size}
  \item{subtitle_face}{plot subtitle family, face and size}
  \item{subtitle_size}{plot subtitle family, face and size}
  \item{subtitle_margin}{plot subtitle margin bottom (single numeric value)}
  \item{strip_text_face}{facet label font family, face and size}
  \item{strip_text_size}{facet label font family, face and size}
  \item{caption_face}{plot caption family, face, size and margin}
  \item{caption_size}{plot caption family, face, size and margin}
  \item{caption_margin}{plot caption family, face, size and margin}
  \item{axis_title_face}{axis title font family, face and size}
  \item{axis_title_size}{axis title font family, face and size}
  \item{axis_title_just}{axis title font justification, one of \code{[blmcrt]}}
  \item{plot_margin}{plot margin (specify with \link[ggplot2:margin]{ggplot2::margin})}
  \item{grid}{panel grid (\code{TRUE}, \code{FALSE}, or a combination of \code{X}, \code{x}, \code{Y}, \code{y})}
  \item{axis}{add x or y axes? \code{TRUE}, \code{FALSE}, "\code{xy}"}
  \item{ticks}{ticks if \code{TRUE} add ticks}
}}
}
\description{
\href{http://mplus-fonts.osdn.jp/design.html#mplus_c1}{M+ C Type 1} fonts are a combination of fixed-fullwidth M+ Type-1 for Japanese and proportional M+ C Type-1 for alphabets.
}
\section{Why Arial Narrow?}{


First and foremost, Arial Narrow is generally installed by default or readily
available on any modern system, so it's "free"-ish; plus, it is a condensed font
with solid default kerning pairs and geometric numbers.

}

\section{Building upon \code{theme_ipsum}}{


The function is setup in such a way that you can customize your own one by just
wrapping the call and changing the parameters. See source for examples.

}

\section{Gotchas}{


There are distinctions between font names and various devices. Names that work
for display graphics devices and bitmap ones such as \code{png} may not work well
for PostScript or PDF ones. You may need two versions of a font-based
theme function for them to work in a particular situation. This situation
usually only arises when using a newer font with many weights but somewhat
irregular internal font name patterns.

}

