% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fa_i.R
\name{fa_i}
\alias{fa_i}
\title{Generate a Font Awesome \verb{<i>} tag}
\usage{
fa_i(name, class = NULL, ..., html_dependency = NULL, verify_fa = TRUE)
}
\arguments{
\item{name}{The name of the Font Awesome icon. This could be as a short name
(e.g., \code{"npm"}, \code{"drum"}, etc.), or, a full name (e.g., \code{"fab fa-npm"},
\code{"fas fa-drum"}, etc.). The names should correspond to current Version 5
Font Awesome names. A list of short and full names can be accessed through
the \code{\link[=fa_metadata]{fa_metadata()}} function with \code{fa_metadata()$icon_names} and
\code{fa_metadata()$icon_names_full}. If supplying a Version 4 icon name, it
will be internally translated to the Version 5 icon name and a Version 5
icon will be returned. A data frame containing the short names that changed
from version 4 (\code{v4_name}) to version 5 (\code{v5_name}) can be obtained by
using \code{fa_metadata()$v4_v5_name_tbl}.}

\item{class}{Additional classes to customize the style of the icon (see the
usage examples for details on supported styles).}

\item{...}{Arguments passed to the \verb{<i>} tag of \link[htmltools:builder]{htmltools::tags}.}

\item{html_dependency}{Provides an opportunity to use a custom
\code{html_dependency} object (created via a call to
\code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}}) instead of one supplied by the function
(which uses Font Awesome's free assets and are bundled in the package). A
custom \code{html_dependency} object is useful when you have paid icons from
Font Awesome or would otherwise like to customize exactly which icon assets
are used (e.g., woff, woff2, eot, etc.). By default, this is \code{NULL} where
the function interally generates an \code{html_dependency}.}

\item{verify_fa}{An option to verify the provided icon \code{name}. If \code{TRUE} (the
default), internal checks will take place and issue messages should the
\code{name} is a Font Awesome 4 icon name (the message will provide the Version
5 name), or, if the icon name cannot be found in either Font Awesome 4 or
5.}
}
\value{
An icon element.
}
\description{
The \code{fa_i()} function creates a Font Awesome \verb{<i>} tag and not an SVG as with
\code{\link[=fa]{fa()}}. The primary use case for \code{fa_i()} is for legacy Shiny applications
that use the \code{shiny::icon()} function. This function is called within a
\code{shiny::icon()} call and all HTML dependencies to support icon generation are
hosted in the \strong{fontawesome} package.
}
\examples{
if (interactive()) {

# Create a Font Awesome icon object
fa_i(name = "r-project")

}

}
