% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_measure.R
\name{install_measure}
\alias{install_measure}
\title{Install python packages dependencies for measure function}
\usage{
install_measure(
  method = "auto",
  conda = "auto",
  envname = NULL,
  extra_packages = NULL,
  pip = F
)
}
\arguments{
\item{method}{Installation method. By default, "auto" automatically finds a
method that will work in the local environment. Change the default to force
a specific installation method. Note that the "virtualenv" method is not
available on Windows.}

\item{conda}{Path to conda executable (or "auto" to find conda using the PATH and other conventional install locations).}

\item{envname}{Name of environment to install packages into.}

\item{extra_packages}{Additional packages if needed.}

\item{pip}{Install from pip, if possible.}
}
\value{
No return value. The function is only called to install the required packages.
}
\description{
The function is a wrapper to install all python packages dependencies for \code{measure} function at once.
It will install the following packages:
\code{numpy}, \code{scipy}, \code{imutils}, \code{Pillow}, \code{pandas},
and \code{opencv-python}.
If the latest versions of these packages are already installed, there is no need to run this function.
}
\details{
On Linux and OS X the "virtualenv" method will be used by default
("conda" will be used if virtualenv isn't available). On Windows,
the "conda" method is always used. For more information check the `reticulate` package documentation:
https://rstudio.github.io/reticulate/
}
