% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPerformanceSpace.R
\name{plotPerformanceSpace}
\alias{plotPerformanceSpace}
\title{Plots a performance space using the system performance and scenarios as input}
\usage{
plotPerformanceSpace(
  performance,
  sim,
  metric = NULL,
  attX = NULL,
  attY = NULL,
  topReps = NULL,
  perfThresh = NULL,
  perfThreshLabel = "Threshold",
  attSlices = NULL,
  climData = NULL,
  colMap = NULL,
  colLim = NULL
)
}
\arguments{
\item{performance}{a named list; contains the system model performance calculated using \code{runSystemModel}. 
If the list contains more than one performance metric, the argument \code{metric} can be used to specify the metric to be used.}

\item{sim}{a list; summary of the simulation containing the scenarios generated using the function \code{generateScenarios} that is used to run the system model using \code{runSystemModel}.
The summary of the simulation may be obtained by using the function \code{getSimSummary} on the full simulation. The summary object is much smaller in size for ease of storage and use with the performance 
plotting functions like \code{plotPerformanceSpace}.}

\item{metric}{a string; the name of the performance metric to be plotted. The argument can be used to select a metric from \code{performance} for plotting. 
If \code{NULL} (the default), the first metric in the list will be used.}

\item{attX}{a string; the tag of the perturbed attribute to plot on the xaxis. The attribute must be one of the perturbed attributes of \code{sim}. 
Type \code{sim$expSpace$attPerturb} to view all perturbed attributes of \code{sim}. If \code{NULL} (default), the first perturbed attribute of \code{sim} will be used.}

\item{attY}{a string; the tag of the perturbed attribute to plot on the yaxis. The attribute must be another perturbed attribute of \code{sim}.
If \code{NULL}, the second perturbed attribute of \code{sim} will be used.}

\item{topReps}{an integer (default is \code{NULL}); the number of "top" replicates in terms of simulation fitness to be used. If \code{topReps} is specified, \code{topReps}
number of replicates will be identified for each target and the average performance across these replicates will be plotted. If \code{NULL}, the average performance across all the replicates will be plotted.}

\item{perfThresh}{a number; the minimum or maximum threshold value of the performance metric. A line will be drawn to mark this threshold value in the performance space.}

\item{perfThreshLabel}{a string; the text to label \code{perfThresh}.}

\item{attSlices}{a list; used to subset perturbed attributes in \code{sim} for the plot. This argument would typically be used in cases where there are more than two perturbed attributes.
The elements of the list correspond to the perturbed attributes to be subsetted and must be named using the attribute tag. Each element may contain a single value or a two-element vector specifying the minimum-maximum values. 
If the element is a single value, the exposure space is sliced on this single value of the attribute. If minimum-maximum values are specified, the exposure space will be sliced to subset this range.
If \code{attSlices} includes \code{attX} or \code{attY}, these attributes will be sliced and the resulting plot will be a "zoomed-in" space.}

\item{climData}{data.frame; the values of attX and attY from other sources like climate models. This data will be plotted as points in the performance space.
The data frame may contain columns with values of the performance metric to be plotted and the "Name" of the dataset. 
If the performance metric is available in the data.frame, the points will be coloured based on the performance \code{colMap} scale.
If the \code{Name} of the data is available in the data.frame, the points will be identified using the \code{Name}. 
Please refer data provided with the package that may be loaded using \code{data("egClimData")} for an example of the expected format of \code{climData}.}

\item{colMap}{a vector of colours; to specify the colourmap to be used. If \code{NULL}, the default foreSIGHT colourmap is used.}

\item{colLim}{a vector of 2 values; the minimum and maximum limits of the colour scale.}
}
\value{
The plot of the performance space and the ggplot object.
}
\description{
\code{plotPerformanceSpace} uses the system model performance calculated using the function \code{runSystemModel} and 
the summary of the simulation generated using the functions \code{generateScenarios} & \code{getSimSummary} as input to plot the performance space of the system.
The user may specify the attributes to be used as the axes of the performance space.
}
\details{
If the space contains more than two perturbed attributes, the performance values are averaged across the perturbations in the attributes other than \code{attX} and \code{attY}.
The user may specify argument \code{attSlices} to slice the performance space at specific values of the other perturbed attributes. If \code{attSlices} are used to 
specify minimum-maximum values to subset other perturbed attributes, the performance values are averaged across the subsetted perturbations in these attributes.
If the input performance list contains multiple performance metrics, the function plots the first metric.
The function may be called with \code{performance} argument specifying the metric to be plotted \code{plotPerformanceSpace(performance[2], sim)} to plot other metrics.
}
\examples{
# load example datasets
data("egSimSummary")       # summary of stochastic simulation
data("egSimPerformance")   # system performance calculated using the stochastic simulation
data("egClimData")         # alternate climate data and system performance

plotPerformanceSpace(egSimPerformance[2], egSimSummary)

# adding climate data, using top 10 replicates
plotPerformanceSpace(egSimPerformance[1], egSimSummary, topReps = 10, climData = egClimData)

# adding a threshold
plotPerformanceSpace(egSimPerformance, egSimSummary, metric = "Avg. Deficit (L)", 
climData = egClimData, perfThresh = 27.5, perfThreshLabel = "Max Avg. Deficit")

# user specified colMap
plotPerformanceSpace(egSimPerformance[1], egSimSummary, climData = egClimData, perfThresh = 27.5, 
perfThreshLabel = "Max Avg. Deficit", colMap = viridisLite::inferno(100))

# example of performance generated using simple scaled simulation
data("egScalPerformance")
data("egScalSummary")
data("egClimData")
plotPerformanceSpace(egScalPerformance[1], egScalSummary, climData = egClimData, 
perfThresh = 28.25, perfThreshLabel = "Max Avg. Deficit")
}
\seealso{
\code{runSystemModel}, \code{generateScenarios}, \code{getSimSummary}, \code{plotPerformanceOAT}
}
