% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unitRoot.R
\name{ndiffs}
\alias{ndiffs}
\title{Number of differences required for a stationary series}
\usage{
ndiffs(x, alpha = 0.05, test = c("kpss", "adf", "pp"), type = c("level",
  "trend"), max.d = 2)
}
\arguments{
\item{x}{A univariate time series}

\item{alpha}{Level of the test, possible values range from 0.01 to 0.1.}

\item{test}{Type of unit root test to use}

\item{type}{Specification of the deterministic component in the regression}

\item{max.d}{Maximum number of non-seasonal differences allowed}
}
\value{
An integer indicating the number of differences required for stationarity.
}
\description{
Functions to estimate the number of differences required to make a given
time series stationary. \code{ndiffs} estimates the number of first
differences necessary.
}
\details{
\code{ndiffs} uses a unit root test to determine the number of differences
required for time series \code{x} to be made stationary. If
\code{test="kpss"}, the KPSS test is used with the null hypothesis that
\code{x} has a stationary root against a unit-root alternative. Then the
test returns the least number of differences required to pass the test at
the level \code{alpha}. If \code{test="adf"}, the Augmented Dickey-Fuller
test is used and if \code{test="pp"} the Phillips-Perron test is used. In
both of these cases, the null hypothesis is that \code{x} has a unit root
against a stationary root alternative. Then the test returns the least
number of differences required to fail the test at the level \code{alpha}.
}
\examples{
ndiffs(WWWusage)
ndiffs(diff(log(AirPassengers),12))

}
\references{
Dickey DA and Fuller WA (1979), "Distribution of the Estimators for
Autoregressive Time Series with a Unit Root", \emph{Journal of the American
Statistical Association} \bold{74}:427-431.

Kwiatkowski D, Phillips PCB, Schmidt P and Shin Y (1992) "Testing the Null
Hypothesis of Stationarity against the Alternative of a Unit Root",
\emph{Journal of Econometrics} \bold{54}:159-178.

Osborn, D.R. (1990) "A survey of seasonality in UK macroeconomic variables",
\emph{International Journal of Forecasting}, \bold{6}:327-336.

Phillips, P.C.B. and Perron, P. (1988) "Testing for a unit root in time series regression",
\emph{Biometrika}, \bold{72}(2), 335-346.

Said E and Dickey DA (1984), "Testing for Unit Roots in Autoregressive
Moving Average Models of Unknown Order", \emph{Biometrika}
\bold{71}:599-607.
}
\seealso{
\code{\link{auto.arima}} and \code{\link{ndiffs}}
}
\author{
Rob J Hyndman, Slava Razbash & Mitchell O'Hara-Wild
}
\keyword{ts}
