% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{tsclean}
\alias{tsclean}
\title{Identify and replace outliers and missing values in a time series}
\usage{
tsclean(x, replace.missing = TRUE, lambda = NULL)
}
\arguments{
\item{x}{time series}

\item{replace.missing}{If TRUE, it not only replaces outliers, but also
interpolates missing values}

\item{lambda}{Box-Cox transformation parameter. If \code{lambda="auto"},
then a transformation is automatically selected using \code{BoxCox.lambda}.
The transformation is ignored if NULL. Otherwise,
data transformed before model is estimated.}
}
\value{
Time series
}
\description{
Uses supsmu for non-seasonal series and a robust STL decomposition for 
seasonal series. To estimate missing values and outlier replacements, 
linear interpolation is used on the (possibly seasonally adjusted) series
}
\examples{

cleangold <- tsclean(gold)

}
\seealso{
\code{\link[forecast]{na.interp}},
\code{\link[forecast]{tsoutliers}}, \code{\link[stats]{supsmu}}
}
\author{
Rob J Hyndman
}
\keyword{ts}
