% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{plot.hybridModel}
\alias{plot.hybridModel}
\title{Plot a hybridModel object}
\usage{
\method{plot}{hybridModel}(x, type = c("fit", "models"),
  ggplot = FALSE, ...)
}
\arguments{
\item{x}{an object of class hybridModel to plot.}

\item{type}{if \code{type = "fit"}, plot the original series and the individual fitted models.
If \code{type = "models"}, use the regular plot methods from the component models, i.e.
\code{\link[forecast]{plot.Arima}}, \code{\link[forecast]{plot.ets}},
\code{\link[forecast]{plot.tbats}}. Note: no plot
methods exist for \code{nnetar} and \code{stlm} objects, so these will not be plotted with
\code{type = "models"}.}

\item{ggplot}{should the \code{\link{autoplot}} function
be used (when available) for the plots?}

\item{...}{other arguments passed to \link{plot}.}
}
\value{
None. Function produces a plot.
}
\description{
Plot a representation of the hybridModel.
}
\details{
For \code{type = "fit"}, the original series is plotted in black.
Fitted values for the individual component models are plotted in other colors.
For \code{type = "models"}, each individual component model is plotted. Since
there is not plot method for \code{stlm} or \code{nnetar} objects, these component
models are not plotted.
}
\examples{
\dontrun{
hm <- hybridModel(woolyrnq, models = "aenst")
plot(hm, type = "fit")
plot(hm, type = "models")
}
}
\seealso{
\code{\link{hybridModel}}
}
\author{
David Shaub
}
