% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_plot.R
\name{class.plot}
\alias{class.plot}
\title{Calculate tree height grading parameters}
\usage{
class.plot(
  data,
  model = "Logistic",
  interval = 5,
  number = 5,
  a = 30,
  b = 10,
  c = 0.5,
  maxiter = 1000
)
}
\arguments{
\item{data}{A data.frame data in which at least four columns are required as input: ID, code, AGE, H.}

\item{model}{Type of model used for building the H model (tree height model), options are `Logistic`, `Richards`, `Korf`, `Gompertz`, `Weibull`, or `Schumacher`.}

\item{interval}{The intervals for tree height classification.}

\item{number}{The maximum value of the tree height classification interval.}

\item{a, b, c}{The initial parameters of the fitted model.}

\item{maxiter}{The maximum number of iterations to fit the model.}
}
\value{
A data of forestData class with output values, models and model parameters.
}
\description{
class.plot adds new variables: the original tree height grading and the adjusted tree height grading. And the existing variables are retained.
}
\details{
Input takes a data.frame with three variables ID,AGE,H and returns the tree height grading value of every sample(rows in the data.frame).
}
\examples{
\donttest{
# Load sample data
data("forestData")

# Build a model based on the forestData and return a forestData class object
forestData <- class.plot(forestData,model="Richards",
                         interval=5,number=5,
                         a=19,b=0.1,c=0.8)
}
}
