% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_forestly.R
\name{meta_forestly}
\alias{meta_forestly}
\title{Create metadata for interactive forest plot}
\usage{
meta_forestly(
  dataset_adsl,
  dataset_adae,
  population_term,
  population_subset = SAFFL == "Y",
  observation_term,
  observation_subset = SAFFL == "Y",
  parameter_term = "any;rel;ser"
)
}
\arguments{
\item{dataset_adsl}{ADSL source dataset.}

\item{dataset_adae}{ADAE source dataset.}

\item{population_term}{A character value of population term name.}

\item{population_subset}{An unquoted condition for selecting the
populations from ADSL dataset.}

\item{observation_term}{A character value of observation term name.}

\item{observation_subset}{An unquoted condition for selecting the
observations from ADAE dataset.}

\item{parameter_term}{A character value of parameter term name.}
}
\value{
A metalite object.
}
\description{
Create metadata for interactive forest plot
}
\examples{
meta_forestly(
  forestly_adsl,
  forestly_adae,
  population_term = "apat",
  observation_term = "wk12"
)
}
