library(testthat)
context("Test for graph.pos range")

test_that("Test for graph.pos compatibility with labeltext as list",{
  pseudomat <- list(Author=list("Smith et al", "Smith et al"), Year=list(2002,2005), N=list(50,75), Weight=list(0.40,0.60))
  mat <- cbind(1:2, 0:1, 4:5)
  expect_silent(forestplot(labeltext = pseudomat, mean=mat, graph.pos="first"))
  expect_silent(forestplot(labeltext = pseudomat, mean=mat, graph.pos="last"))
  expect_silent(forestplot(labeltext = pseudomat, mean=mat, graph.pos=1))
  expect_silent(forestplot(labeltext = pseudomat, mean=mat, graph.pos=4))
  expect_silent(forestplot(labeltext = pseudomat, mean=mat, graph.pos=5))
  expect_error(forestplot(labeltext = pseudomat, mean=mat, graph.pos=6))
  expect_error(forestplot(labeltext = pseudomat, mean=mat, graph.pos=0))
  expect_error(forestplot(labeltext = pseudomat, mean=mat, graph.pos=-5))
})

test_that("Test for graph.pos compatibility with labeltext as matrix",{
  pseudomat <- cbind(Author=c("Smith et al", "Smith et al"), Year=c(2002,2005), N=c(50,75), Weight=c(0.40,0.60))
  mat <- cbind(1:2, 0:1, 4:5)
  expect_silent(forestplot(labeltext = pseudomat, mean=mat, graph.pos="first"))
  expect_silent(forestplot(labeltext = pseudomat, mean=mat, graph.pos="last"))
  expect_silent(forestplot(labeltext = pseudomat, mean=mat, graph.pos=1))
  expect_silent(forestplot(labeltext = pseudomat, mean=mat, graph.pos=4))
  expect_silent(forestplot(labeltext = pseudomat, mean=mat, graph.pos=5))
  expect_error(forestplot(labeltext = pseudomat, mean=mat, graph.pos=6))
  expect_error(forestplot(labeltext = pseudomat, mean=mat, graph.pos=0))
  expect_error(forestplot(labeltext = pseudomat, mean=mat, graph.pos=-5))
})


test_that("Test for graph.pos compatibility with labeltext as vector",{
  pseudomat <- c("Smith et al", "Smith et al")
  mat <- cbind(1:2, 0:1, 4:5)
  expect_silent(forestplot(labeltext = pseudomat, mean=mat, graph.pos="first"))
  expect_silent(forestplot(labeltext = pseudomat, mean=mat, graph.pos="last"))
  expect_silent(forestplot(labeltext = pseudomat, mean=mat, graph.pos=1))
  expect_silent(forestplot(labeltext = pseudomat, mean=mat, graph.pos=2))
  expect_error(forestplot(labeltext = pseudomat, mean=mat, graph.pos=3))
  expect_error(forestplot(labeltext = pseudomat, mean=mat, graph.pos=0))
  expect_error(forestplot(labeltext = pseudomat, mean=mat, graph.pos=-5))
})
