% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestplot_helpers.R
\name{fpTxtGp}
\alias{fpTxtGp}
\title{Get font settings for forestplot}
\usage{
fpTxtGp(label, summary, xlab, title, ticks, legend, legend.title, cex = 1)
}
\arguments{
\item{label}{The text labels (see details below)}

\item{summary}{The summary labels (see details below)}

\item{xlab}{The xlab text}

\item{title}{The plot title}

\item{ticks}{The ticks associated with the xlab}

\item{legend}{The legend text}

\item{legend.title}{The legend title}

\item{cex}{The font size}
}
\value{
A list of the \code{fpTxtGp} class
}
\description{
This function generates all the \code{\link[grid]{gpar}()}
elements for the different text elements within the graph.
Elements not specified inherit their default settings from the
\code{label} argument.
}
\section{List arguments for \code{label}/\code{summary}}{


You can provide a \code{list} of elements for the \code{label}
and \code{summary} in order to specify separate elements. If you
provide a \code{list} in one dimension the \code{gpar} elements are assumed
to follow the columns. If you provide a \code{list} of 2 dimensions the
structure assumes is \code{list[[row]][[column]]} and the number of elements
should correspond to the number of labels for the \code{label} argument, i.e.
without the rows marked as summary elements. The same goes for \code{summary}
arguments.
}

\examples{
fpTxtGp(label = gpar(fontfamily = "HersheySerif"))
}
