% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.R
\name{forest}
\alias{forest}
\title{Forest plot}
\usage{
forest(
  data,
  est,
  lower,
  upper,
  sizes = 0.4,
  ref_line = ifelse(x_trans \%in\% c("log", "log2", "log10"), 1, 0),
  vert_line = NULL,
  ci_column,
  is_summary = NULL,
  xlim = NULL,
  ticks_at = NULL,
  ticks_digits = 1L,
  arrow_lab = NULL,
  x_trans = "none",
  xlab = NULL,
  footnote = NULL,
  title = NULL,
  nudge_y = 0,
  fn_ci = makeci,
  fn_summary = make_summary,
  index_args = NULL,
  theme = NULL,
  ...
)
}
\arguments{
\item{data}{Data to be displayed in the forest plot}

\item{est}{Point estimation. Can be a list for multiple columns
and/or multiple groups. If the length of the list is larger than
then length of \code{ci_column}, then the values reused for each column
and considered as different groups.}

\item{lower}{Lower bound of the confidence interval, same as \code{est}.}

\item{upper}{Upper bound of the confidence interval, same as \code{est}.}

\item{sizes}{Size of the point estimation box, can be a unit, vector or a list.
Values will be used as it is, no transformation will be applied.}

\item{ref_line}{X-axis coordinates of zero line, default is 1. Provide an atomic
vector if different reference line for each \code{ci_column} is desired.}

\item{vert_line}{Numerical vector, add additional vertical line at given value.
Provide a list of numerical vector element if different vertical line for each
\code{ci_column} is desired.}

\item{ci_column}{Column number of the data the CI will be displayed.}

\item{is_summary}{A logical vector indicating if the value is a summary value,
which will have a diamond shape for the estimate. Can not be used with multiple
group \code{forestplot}.}

\item{xlim}{Limits for the x axis as a vector of length 2, i.e. c(low, high). It
will take the minimum and maximum of the lower and upper value if not provided.
This will apply to all CI columns if provided, and will be calculated automatically
for each column if not provided. This should be a list with the same length of
\code{ci_column} if different \code{xlim} for different column is desired.}

\item{ticks_at}{Set X-axis tick-marks point. This will apply to all CI columns if
provided, and will be calculated automatically for each column if not provided.
This should be a list if different \code{ticks_at} for different column is desired.
Although many efforts have been made to automatically get a pretty ticks break,
it will not give a perfect solution, especially if \code{'log2'} and \code{'log10'}
defined for \code{x_trans}. Please provide this value if possible.}

\item{ticks_digits}{Number of digits for the x-axis, default is \code{1L}. This
should be a numerical vector if different rounding will be applied to different
column. If an integer is specified, for example \code{1L}, trailing zeros after
the decimal mark will be dropped. Specify numeric, for example \code{1}, to keep
the trailing zero after the decimal mark.}

\item{arrow_lab}{Labels for the arrows, string vector of length two (left and
right). The theme of arrow will inherit from the x-axis. This should be a list
if different arrow labels for each column is desired.}

\item{x_trans}{Change axis scale, Allowed values are one of c("none", "log", "log2",
"log10"). Default is \code{"none"}, no transformation will be applied.
The formatted label will be used for \code{scale  = "log2"} or \code{"log10"}, change
this in \code{x_trans}. Set this to \code{"log"} if x-axis tick marks assume values
are exponential, e.g. for logistic regression (OR), survival estimates (HR), Poisson
regression etc.}

\item{xlab}{X-axis labels, it will be put under the x-axis. An atomic vector should
be provided if different \code{xlab} for different column is desired.}

\item{footnote}{Footnote for the forest plot, will be aligned at left bottom
of the plot. Please adjust the line length with line break to avoid the overlap
with the arrow and/or x-axis.}

\item{title}{The text for the title.}

\item{nudge_y}{Horizontal adjustment to nudge groups by, must be within 0 to 1.}

\item{fn_ci}{Name of the function to draw confidence interval, default is
\code{\link{makeci}}. You can specify your own drawing function to draw the
confidence interval, but the function needs to accept arguments \code{
"est", "lower", "upper", "sizes", "xlim", "pch", "gp", "t_height", "nudge_y"}.
Please refer to the \code{\link{makeci}} function for the details of these
parameters.}

\item{fn_summary}{Name of the function to draw summary confidence interval,
default is \code{\link{make_summary}}. You can specify your own drawing
function to draw the summary confidence interval, but the function needs to
accept arguments \code{"est", "lower", "upper", "sizes", "xlim", "gp"}.
Please refer to the \code{\link{make_summary}} function for the details of
these parameters.}

\item{index_args}{A character vector, name of the arguments used for indexing
the row and coloumn. This should be the name of the arguments that is working
the same way as \code{est}, \code{lower} and \code{upper}. Check out the
examples in the \code{\link{make_boxplot}}.}

\item{theme}{Theme of the forest plot, see \code{\link{forest_theme}} for
details.}

\item{...}{Other arguments passed on to the \code{fn_ci} and \code{fn_summary}.}
}
\value{
A \code{\link[gtable]{gtable}} object.
}
\description{
A data frame will be used for the basic layout of the forest plot.
Graphical parameters can be set using the \code{\link{forest_theme}} function.
}
\examples{
# Read provided sample example data
dt <- read.csv(system.file("extdata", "example_data.csv", package = "forestploter"))

# Keep needed columns
dt <- dt[,1:6]

# indent the subgroup if there is a number in the placebo column
dt$Subgroup <- ifelse(is.na(dt$Placebo),
                      dt$Subgroup,
                      paste0("   ", dt$Subgroup))

# NA to blank or NA will be transformed to carachter.
dt$Treatment <- ifelse(is.na(dt$Treatment), "", dt$Treatment)
dt$Placebo <- ifelse(is.na(dt$Placebo), "", dt$Placebo)
dt$se <- (log(dt$hi) - log(dt$est))/1.96

# Add blank column for the forest plot to display CI.
# Adjust the column width with space.
dt$` ` <- paste(rep(" ", 20), collapse = " ")

# Create confidence interval column to display
dt$`HR (95\% CI)` <- ifelse(is.na(dt$se), "",
                             sprintf("\%.2f (\%.2f to \%.2f)",
                                     dt$est, dt$low, dt$hi))

# Define theme
tm <- forest_theme(base_size = 10,
                   refline_col = "red",
                   footnote_col = "#636363",
                   footnote_fontface = "italic")

p <- forest(dt[,c(1:3, 8:9)],
            est = dt$est,
            lower = dt$low,
            upper = dt$hi,
            sizes = dt$se,
            ci_column = 4,
            ref_line = 1,
            arrow_lab = c("Placebo Better", "Treatment Better"),
            xlim = c(0, 4),
            ticks_at = c(0.5, 1, 2, 3),
            footnote = "This is the demo data. Please feel free to change\nanything you want.",
            theme = tm)

# Print plot
plot(p)
}
\seealso{
\code{\link[gtable]{gtable}} \code{\link[gridExtra]{tableGrob}}
\code{\link{forest_theme}} \code{\link{make_boxplot}}
\code{\link{makeci}}  \code{\link{make_summary}}
}
