% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerPlot.R
\name{powerPlot}
\alias{powerPlot}
\title{Exclusion/inclusion power plots}
\usage{
powerPlot(
  ep,
  ip,
  type = 1,
  ellipse = FALSE,
  col = NULL,
  labs = NULL,
  alpha = 1,
  shape = "circle",
  size = 2,
  hline = NULL,
  vline = NULL,
  xlim = NULL,
  ylim = NULL,
  xlab = NULL,
  ylab = NULL,
  legendOrder = NULL
)
}
\arguments{
\item{ep, ip}{Lists of equal length, with outputs from one or more runs of
\code{\link[=missingPersonEP]{missingPersonEP()}} and \code{\link[=missingPersonIP]{missingPersonIP()}} respectively. Alternatively,
\code{ep} can be a single output from \code{\link[=MPPsims]{MPPsims()}}, in which case \code{ip} should be
NULL. See Examples.}

\item{type}{Plot type; either 1, 2, 3 or 4.}

\item{ellipse}{A logical. If TRUE, data ellipsis are drawn for each group
containing more than 1 element. NB: This fails with a warning if all points
in a group fall on a line.}

\item{col}{A colour vector, recycle to match the top level length of \code{ep}.}

\item{labs}{A character of the same length as \code{ep}. If NULL, the names of
\code{ep} are used, if present.}

\item{alpha}{Transparency for minor points (see Details).}

\item{shape}{Either "circle", "square", "diamond", "triangleUp" or
"triangleDown", determining the shapes of both minor and major points.}

\item{size}{Point size.}

\item{hline, vline}{Single numbers indicating positions for
horizontal/vertical "threshold" lines. When \code{type = 1}, these determine the
shaded vertical regions, by default starting at 0.95.}

\item{xlim, ylim}{Axis limits; automatically chosen if NULL.}

\item{xlab, ylab}{Axis labels; automatically chosen if NULL.}

\item{legendOrder}{A permutation of \verb{1,2,...,L}, where \code{L = length(ep)}.}
}
\value{
A \code{ggplot2} plot object.
}
\description{
This function offers four different visualisations of exclusion/inclusion
powers, particularly for missing person cases. Output from \code{\link[=MPPsims]{MPPsims()}} may be
fed directly as input to this function. The actual plotting is done with
\code{ggplot2}.
}
\details{
The plot types are as follows:

\code{type = 1}: x = Exclusion power; y = Inclusion power

\code{type = 2}: x = Exclusion odds ratio; y = Inclusion odds ratio

\code{type = 3}: x = Expected number of exclusions; y = average log(LR)

\code{type = 4}: x = Exclusion power; y = average LR

For each \code{EPresult} object in \code{ep}, and the corresponding element of \code{ip},
the relevant data is extracted from each, producing a single point the final
plot.

In the most general case \code{ep} (and similarly for \code{ip}) can be a list of lists
of \code{EPresult} objects. To simplify the discussion we refer to the inner lists
as "groups". A group may consist of a single point, or several (typically
many simulations of the same situation). Points within the same group are
always drawn with the same colour and shape.

When plotting several groups, two sets of points are drawn:
\itemize{
\item Major points: Group means.
\item Minor points: Individual points in groups with more than one element.
}
}
\examples{

ref = nuclearPed(father = "fa", mother = "mo", child = "MP")
ref = setMarkers(ref, marker(ref, alleles = 1:5))

# Alternatives for genotyping
sel = list("fa", c("fa", "mo"))

# Simulate power for each selection
simData = MPPsims(ref, selections = sel, nProfiles = 5,
                  lrSims = 10, thresholdIP = 2, seed = 123)

# Power plot 1: EP vs IP
powerPlot(simData, type = 1)

\donttest{

# Change shape, and modify legend order
powerPlot(simData, type = 1, shape = c("ci", "sq", "di"), legendOrder = 3:1)

# Zoom in, and adjust the blue strips
powerPlot(simData, type = 1, xlim = c(0.4, 1), ylim = c(0.4, 1),
          hline = 0.8, vline = 0.8)

# Power plot 3: Expected number of exclusions vs E[log LR]
powerPlot(simData, type = 3)

# With horizontal/vertical lines
powerPlot(simData, type = 3, hline = log10(2), vline = 1)

# Plot 4: Illustrating the general inequality ELR > 1/(1-EP)
powerPlot(simData, type = 4)

}

}
\seealso{
\code{\link[=MPPsims]{MPPsims()}}, \code{\link[=missingPersonEP]{missingPersonEP()}}, \code{\link[=missingPersonEP]{missingPersonEP()}}
}
