% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeFam.R
\name{writeFam}
\alias{writeFam}
\title{Convert \code{ped} objects to \code{Familias} format}
\usage{
writeFam(..., famfile = "ped.fam", theta = 0)
}
\arguments{
\item{...}{One or several pedigrees. Each argument should be either a single
\code{ped} object or a list of such. If the pedigrees are unnamed, they are
assigned names "Ped 1", "Ped 2", etc.}

\item{famfile}{The name or path to the output file to be written. The
extension ".fam" is added if missing.}

\item{theta}{A nonnegative number indicating a theta correction for the
marker database. By default 0.}
}
\value{
The filename is returned invisibly.
}
\description{
This function produces a .fam file readable by the \code{Familias} software,
containing all input pedigrees and their marker data.
}
\examples{
library(pedprobr)

x = nuclearPed(father = "AF", mother = "MO", children = "CH") |>
  profileSim(N = 1, ids = c("AF", "CH"), seed = 111,
             markers = NorwegianFrequencies[1:2])

# Write to .fam
tmp = writeFam(x, famfile = tempfile())

# Read back in
y = readFam(tmp)

# Verify that likelihoods agree
stopifnot(all.equal(likelihood(x),
                    likelihood(y)))


### With stepwise mutation model
x2 = setMutmod(x, model = "stepwise",
               rate = list(male = 0.001, female = 0.002),
               range = 0.1, rate2 = 0.0001)

y2 = x2 |> writeFam(famfile = tempfile()) |> readFam()

stopifnot(all.equal(likelihood(x2), likelihood(y2)))

}
\seealso{
\code{\link[=readFam]{readFam()}}
}
