% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibdBootstrap.R
\name{ibdBootstrap}
\alias{ibdBootstrap}
\title{Bootstrap estimation of IBD coefficients}
\usage{
ibdBootstrap(
  x = NULL,
  ids = NULL,
  param = NULL,
  kappa = NULL,
  delta = NULL,
  N,
  method = "parametric",
  freqList = NULL,
  plot = TRUE,
  seed = NULL
)
}
\arguments{
\item{x}{A \code{ped} object, or a list of such. If \code{method = "parametric"}, this
is only used to extract the allele frequencies, and can be skipped if
\code{freqList} is provided.}

\item{ids}{A pair of ID labels.}

\item{param}{Either NULL (default), "kappa" or "delta". (See below.)}

\item{kappa, delta}{Probability vectors of length 3 (kappa) or 9 (delta).
Exactly one of \code{param}, \code{kappa} and \code{delta} must be non-NULL. If \code{kappa}
and \code{delta} are both NULL, the appropriate set of coefficients is computed
as \code{ibdEstimate(x, ids, param)}.}

\item{N}{The number of simulations.}

\item{method}{Either "parametric" (default) or "nonparametric". Abbreviations
are allowed. see Details for more information about each method.}

\item{freqList}{A list of probability vectors: The allele frequencies for
each marker.}

\item{plot}{A logical, only relevant for bootstraps of kappa. If TRUE, the
bootstrap estimates are plotted in the IBD triangle.}

\item{seed}{An integer seed for the random number generator (optional).}
}
\value{
A data frame with \code{N} rows containing the bootstrap estimates. The
last column, \code{dist}, gives the Euclidean distance to the original
coefficients (either specified by the user or estimated from the data),
viewed as a point in R^3 (kappa) or R^9 (delta).
}
\description{
This function produces (parametric or nonparametric) bootstrap estimates of
the IBD coefficients between two individuals; either the three \eqn{\kappa}
-coefficients or the nine condensed identity coefficients \eqn{\Delta} (see
\code{\link[=ibdEstimate]{ibdEstimate()}}).
}
\details{
The parameter \code{method} controls how bootstrap estimates are obtained in each
replication:
\itemize{
\item "parametric": new profiles for two individuals are simulated
from the input coefficients, followed by a re-estimation of the coefficients.
\item "nonparametric": the original markers are sampled with replacement, before
the coefficients are re-estimated.
}

Note that the pedigree itself does not affect the output of this function;
the role of \code{x} is simply to carry the marker data.
}
\examples{

# Frequency list of 15 standard STR markers
freqList = NorwegianFrequencies[1:15]

# Number of bootstrap simulations (increase!)
N = 5

# Bootstrap estimates for kappa of full siblings
boot1 = ibdBootstrap(kappa = c(0.25, .5, .25), N = N, freqList = freqList)
boot1

# Mean deviation
mean(boot1$dist)

# Same, but with the 9 identity coefficients.
delta = c(0, 0, 0, 0, 0, 0, .25, .5, .25)
boot2 = ibdBootstrap(delta = delta, N = N, freqList = freqList)

# Mean deviation
mean(boot2$dist)

#### Non-parametric bootstrap.
# Requires `x` and `ids` to be provided

x = nuclearPed(2)
x = markerSim(x, ids = 3:4, N = 50, alleles = 1:10, seed = 123)

bootNP = ibdBootstrap(x, ids = 3:4, param = "kappa", method = "non", N = N)

# Parametric bootstrap can also be done with this syntax
bootP = ibdBootstrap(x, ids = 3:4, param = "kappa", method = "par", N = N)

}
\seealso{
\code{\link[=ibdEstimate]{ibdEstimate()}}
}
