% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankProfiles.R
\name{rankProfiles}
\alias{rankProfiles}
\title{Find the most likely profiles of a pedigree member}
\usage{
rankProfiles(x, id, markers = NULL, maxPerMarker = Inf, verbose = FALSE)
}
\arguments{
\item{x}{A \code{ped} object with attached markers.}

\item{id}{The name of a single (typically untyped) pedigree member.}

\item{markers}{Names or indices of the markers to be included. Default: all.}

\item{maxPerMarker}{A single number, limiting the number of top genotypes
considered for each marker. Default: \code{Inf} (no restriction).}

\item{verbose}{A logical, by default FALSE.}
}
\value{
A list with the following components (\code{N} denotes the number of
markers):
\itemize{
\item \code{profiles}: A data frame with \code{N+1} columns, containing the possible
profiles, ranked by likelihood.
\item \code{marginal1}: A numeric of length \code{N}, giving the marginal
probability of the most likely genotype for each marker.
\item \code{marginal2}: A numeric of length \code{N}, with marginals for the \emph{second} most
likely genotype for each marker, or \code{NA} if there is no second.
\item \code{best}: A character of length \code{N} containing the most likely profile.
This is the same as \code{names(marginal1)}, and also as \code{profiles[1, 1:N]}.
}
}
\description{
Identify and rank the most likely DNA profiles of a pedigree member. For each
marker, the possible genotypes of the indicated person are ranked by
likelihood.
}
\details{
Note that this function assumes that all markers are independent.

If the marker data includes mutation models, it may be wise to try first with
\code{maxPerMarker = 1} to limit computation time.
}
\examples{

x = nuclearPed(nch = 4) |>
   markerSim(N = 4, alleles = c("a", "b", "c"), seed = 1, verbose = FALSE)
x
# Remove data for father
y = setAlleles(x, ids = 1, alleles = 0)

# Most likely profiles of father
rankProfiles(y, id = 1)

# Compare with truth
getGenotypes(x, ids = 1)

# Same example with mutations allowed
z = setMutmod(y, model = "equal", rate = 0.01)
rankProfiles(z, id = 1)

}
