% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainNN.R
\name{trainNN}
\alias{trainNN}
\title{Train and assess accuracy of a k-NN model}
\usage{
trainNN(
  x,
  y,
  inTrain = NULL,
  inTest = NULL,
  k = 1,
  method = "randomForest",
  impute.cont = NULL,
  impute.fac = NULL,
  ntree = 500,
  mtry = NULL,
  rfMode = "",
  ...
)
}
\arguments{
\item{x}{A dataframe or SpatialPointsDataFrame of predictors variables X for
reference observations. Row names of X are used as identification of
reference observations.}

\item{y}{A dataframe or SpatialPointsDataFrame of response variables Y for the
reference observations. Row names of Y are used as identification of
reference observations.}

\item{inTrain}{Optional. A list obtained from
\code{\link[foster]{partition}}indicating which rows of x and y go to
training.}

\item{inTest}{Optional list indicating which rows of x and y go to validation.
If left NULL, all rows that are not in \code{inTrain} are used for
validation.}

\item{k}{Integer. Number of nearest neighbors}

\item{method}{Character. Which nearness metrics is used to compute the nearest
neighbors. Default is \code{"randomForest"}. Other methods are listed in
\code{\link[yaImpute]{yai}}}

\item{impute.cont}{Character. The method used to compute the imputed
continuous variables. Can be \code{"closest"}, \code{"mean"},
\code{"median"} or \code{"dstWeighted"}. Default is \code{"closest"} if
\code{k = 1} and \code{"dstWeighted"} if \code{k > 1}. See
\code{\link[yaImpute]{impute.yai}} for more details.}

\item{impute.fac}{Character. The method used to compute the imputed values for
factors. Default value is the same as \code{impute.cont}. See
\code{\link[yaImpute]{impute.yai}} for more details.}

\item{ntree}{Number of classification or regression trees drawn for each
response variable. Default is 500}

\item{mtry}{Number of X variables picked randomly to split each node. Default
is sqrt(number of X variables)}

\item{rfMode}{By default, \code{rfMode} is set to \code{""} which forces
\code{\link[yaImpute]{yai}} to create random forest regression trees instead
of classification trees for continuous variables. Can be set to
\code{"buildClasses"} if  wanting continuous variables to be converted to
classes and forcing random forest to build classification trees. (See
\code{\link[yaImpute]{yai}})}

\item{...}{Other arguments passed to \code{\link[yaImpute]{yai}} (e.g.
\code{"rfXsubsets"})}
}
\value{
A list containing the following objects: \describe{
  \item{\code{model}}{A \code{yai} object, the trained k-NN model}
  \item{\code{preds}}{A data.frame with observed and predicted values of the
  testing set for each response variables} }
}
\description{
This function trains a k-NN model from response variables (Y) and predictors
(X) at reference observations using the package yaImpute (see
\code{\link[yaImpute]{yai}}). By default, the distance between observations
is obtained from the proximity matrix of random forest regression or
classification trees. Optionally, training and testing sets can be provided
to return the accuracy of the trained k-NN model.
}
\details{
If performing model validation, the function trains a kNN model from the
training set, finds the k NN of the validation set and imputes the response
variables from the k NN. If \code{k = 1}, only the closest NN value is
imputed. If k > 1, the imputed value can be either the closest NN value, the
mean, median or distance weighted mean of the k NN values.This is controlled
by the arguments \code{impute.cont} or \code{impute.fac}.

If inTest = NULL, all rows that are not in inTrain will be used for model
testing. If inTrain = NULL, all rows that are not in inTest will be used for
model training. If both inTrain and inTest are NULL, all rows of x and y will
be used for training and no testing is performed.

The final model returned by \code{findNN} is trained from all observations of
\code{x} and \code{y}.
}
\examples{
# Load data in memory
# X_vars_sample: Predictor variables at sample (from getSample)
# Y_vars_sample: Response variables at sample (from getSample)
# train_idx: Rows of X_vars_sample and Y_vars_sample that are used for
# training (from (partition))
load(system.file("extdata/examples/example_trainNN.RData",package="foster"))

set.seed(1234) #for example reproducibility
kNN <- trainNN(x = X_vars_sample,
               y=Y_vars_sample,
               inTrain = train_idx,
               k = 1,
               method = "randomForest",
               ntree = 200)
}
\seealso{
\code{\link[yaImpute]{yai}}, \code{\link[yaImpute]{newtargets}},
  \code{\link[yaImpute]{impute.yai}}, \code{\link[foster]{accuracy}}
}
