% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_transect_list.R
\name{download_transect_list}
\alias{download_transect_list}
\title{Download multiple floristic quality transect assessments}
\usage{
download_transect_list(database_id, ...)
}
\arguments{
\item{database_id}{Numeric identifier of the desired floristic quality
assessment database, as specified by
\href{https://universalfqa.org/}{universalfqa.org}. Database id numbers can
be viewed with the \code{\link[=index_fqa_databases]{index_fqa_databases()}}
function.}

\item{...}{\code{dplyr}-style filtering criteria for the desired transect
  assessments. The following variables may be used:
\itemize{
  \item id (numeric)
  \item assessment (character)
  \item date (date)
  \item site (character)
  \item practitioner (character)
}}
}
\value{
A list of data frames matching the search criteria. Each is an untidy
  data frame in the original format of the Universal FQA website. Use
  \code{\link[=transect_list_glance]{transect_list_glance()}} for a tidy
  summary.
}
\description{
\code{download_transect_list()} searches a specified floristic quality
assessment database and retrieves all matches from
\href{https://universalfqa.org/}{universalfqa.org}. Download speeds from that
website may be slow, causing delays in the evaluation of this function.
}
\examples{
\donttest{
databases <- index_fqa_databases()
# Note database 1 is the original 1994 Chicago edition.
dupont <- download_transect_list(1, site == "DuPont Natural Area")
}

}
