% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.fmm}
\alias{plot.fmm}
\title{Plot the baseline hazard or the predicted hazard based on the new data}
\usage{
##S3 method for class "fmm"
}
\arguments{
\item{newdata}{The new data for prediction of hazard}

\item{surv}{Plot survival curve instead of cumulative hazard, the default is \code{FALSE}}

\item{...}{Further arguments pass to or from other methods}

\item{object}{Object with class "fmm"}
}
\description{
Both the cumulative hazard and the survival curves can be plotted.
}
\details{
If parameter \code{newdata} is given, the plot is based on the predicted hazard while if it is not given,
the plot is based on the baseline hazard. To construct the new data, please refer to the detailed description from 
function \code{predict.fmm} and the following example.
}
\examples{

\donttest{
gam_re = frailtyMM(Surv(tstart, tstop, status) ~  sex + treat + cluster(id), cgd, frailty = "Gamma")

# Plot the survival curve based on baseline hazard
plot(gam_re, surv = TRUE)

# Construct new data and plot the cumulative hazard based on new data
newre = c(1, 1, 2)
names(newre) = c(gam_re$coefname, "id")
plot(gam_re, newdata = newre)
}
}
\seealso{
\code{\link{predict.fmm}}
}
