% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.jointSurroPenal.R
\name{plot.jointSurroPenal}
\alias{plot.jointSurroPenal}
\alias{lines.jointSurroPenal}
\title{Plot Method for the one-step Joint surrogate model for the evaluation of a 
canditate surrogate endpoint.}
\usage{
\method{plot}{jointSurroPenal}(x, type.plot = "Hazard", conf.bands=TRUE,
pos.legend = "topright", cex.legend=0.7, main, color=2, Xlab = "Time", Ylab
= "Baseline hazard function", xmin = 0, xmax = NULL, ylim = c(0,1), endpoint = 2, 
scale = 1, ...)
}
\arguments{
\item{x}{An object inheriting from \code{jointSurroPenal} class
(output from calling \code{jointSurroPenal} function).}

\item{type.plot}{A character string specifying the type of curve. Possible
value are "Hazard", or "Survival". The default is "Hazard". Only the first
letters are required, e.g "Haz", "Su".}

\item{conf.bands}{Logical value. Determines whether confidence bands will
be plotted.  The default is to do so.}

\item{pos.legend}{The location of the legend can be specified by setting
this argument to a single keyword from the list '"bottomright"',
'"bottom"', '"bottomleft"', '"left"', '"topleft"', '"top"', '"topright"',
'"right"' and '"center"'. The default is '"topright"'.}

\item{cex.legend}{Character expansion factor *relative* to current
'par("cex")'. Default is 0.7.}

\item{main}{Title of plot.}

\item{color}{Color of the curve (integer).}

\item{Xlab}{Label of x-axis. Default is '"Time"'.}

\item{Ylab}{Label of y-axis. Default is '"Baseline hazard function"'.}

\item{xmin}{Minimum value for x-axis, the default is \code{0}.}

\item{xmax}{Maximum value for x-axis, the default is \code{NULL}.}

\item{ylim}{Range of y-axis. Default is from 0 to 1.}

\item{endpoint}{A binary that indicates the endpoint to represent. \code{0} for
the surrogate endpoint, \code{1} for the true endpoint, and \code{2} for both
surrogate endpoint and true endpoint. The default is \code{2}.}

\item{scale}{A numeric that allows to rescale the survival times. If no change is need the
argument is set to 1, the default value. eg: 1/365 aims to convert days to years ".}

\item{...}{other unused arguments.}
}
\value{
Print a plot of the baseline survival or hazard functions for each
type of event or both with the confidence bands or not (conf.bands
argument)
}
\description{
Plots estimated baseline survival and hazard functions for the surrogate 
endpoint and the true endpoint from an object of class 'jointSurroPenal'. 
Confidence bands are allowed.
}
\examples{


\dontrun{


###--- Joint surrogate model ---###
###---evaluation of surrogate endpoints---###

data(dataOvarian)
joint.surro.ovar <- jointSurroPenal(data = dataOvarian, n.knots = 8, 
                init.kappa = c(2000,1000), indice.alpha = 0, nb.mc = 200, 
                scale = 1/365)

# Baseline Hazards fonctions for both the surrogate endpoint 
# and the true endpoint
plot(joint.surro.ovar,endpoint = 2,type.plot = "Haz", conf.bands = T)   

# Baseline survival fonctions for both the surrogate endpoint 
# and the true endpoint
plot(joint.surro.ovar,endpoint = 2,type.plot = "Su", conf.bands = T)  
             


}


}
\seealso{
\code{\link{jointSurroPenal}}
}
\keyword{surrogate}
