% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHelp.R
\docType{data}
\name{dataOvarian}
\alias{dataOvarian}
\title{Advanced Ovarian Cancer dataset}
\format{This data frame contains the following columns: 
\describe{
\item{patientID}{The identification number of a patient} 
\item{trialID}{The center in which a patient was treated}
\item{trt}{The treatment indicator, coded as 0 = cyclophosphamide plus cisplatin (CP)
and 1 = cyclophosphamide plus adriamycin plus cisplatin(CAP)}
\item{timeS}{The candidate surrogate (progression-free survival)}
\item{statusS}{Censoring indicator for for Progression-free survival}
\item{timeT}{The true endpoint (survival time)}
\item{statusT}{Censoring indicator for survival time}
}}
\source{
Ovarian cancer Meta-Analysis Project (1991). Cyclophosphamide plus cisplatin plus adriamycin
versus Cyclophosphamide, doxorubicin, and cisplatin chemotherapy of ovarian carcinoma: 
A meta-analysis. \emph{Classic Papers and Current Comments}, \bold{3}, 237-234.
}
\usage{
data(dataOvarian)
}
\description{
This dataset combines the data  that were collected in four double-blind randomized
clinical trials in advanced ovarian cancer. In these trials, the objective was to 
examine the efficacy of cyclophosphamide plus cisplatin (CP) versus cyclophosphamide 
plus adriamycin plus cisplatin (CAP) to treat advanced ovarian cancer. The candidate 
surrogate endpoint \bold{S} is progression-free survival time, defined as the time (in years)
from randomization to clinical progression of the disease or death. The true endpoint
\bold{T} is survival time, defined as the time (in years) from randomization to death of any 
cause
}
\keyword{datasets}
