% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setters.R
\name{set_date}
\alias{set_date}
\title{set date}
\usage{
set_date(.data, ..., date_fn = lubridate::ymd)
}
\arguments{
\item{.data}{dataframe}

\item{...}{tidyselect}

\item{date_fn}{a function to convert to a date object}
}
\value{
tibble
}
\description{
set dates manually or automatically
}
\details{
note: can be called without any `...` arguments and instead automatically determines which character columns
are actually dates, then proceeds to set them. It checks for the date specified in `date_fn` and also \code{lubridate::ymd_hms}.
On auto detect mode, it sets `ymd_hms` output to ymd dates instead of datetimes with hms. This is because of the common occurrence
of trying to extract a `ymd` date from an excel workbook, and having it come with extra 00:00:00. If you need a datetime, manually
supply the appropriate lubridate function.

Auto mode is experimental. Commonly detected error is a long character string of integers being interpreted as a date.
}
\examples{

tibble::tibble(date = c("20190101", "20170205")) \%>\%
set_date()
}
