% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_docs.R
\name{fredr_docs}
\alias{fredr_docs}
\title{Open the web documentation for a certain FRED API topic.}
\usage{
fredr_docs(endpoint = "base", params = FALSE, debug = FALSE)
}
\arguments{
\item{endpoint}{A string representing the desired documentation for the exact
FRED API endpoint.  Default is \code{"base"}, which will open a link to
\url{https://api.stlouisfed.org/docs/fred/}.}

\item{params}{A boolean value.  If \code{TRUE}, the documentation will be opened at
the "Parameters" section.  Default is \code{FALSE}.}

\item{debug}{A boolean value.  If \code{TRUE}, the documentation is not opened in a
browser and the documentation URL is returned as a string.  If \code{FALSE},
documentation is opened in a browser and nothing is returned.  Default is
\code{FALSE}.}
}
\description{
Opens FRED API web documentation in a new browser tab.
}
\section{API Documentation}{


\href{https://api.stlouisfed.org/docs/fred/}{FRED API}
}

\examples{
fredr_docs()
fredr_docs(endpoint = "category")
fredr_docs(endpoint = "series/observations")
fredr_docs(endpoint = "series/observations", params = TRUE)
}
