% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_sources.R
\name{fredr_sources}
\alias{fredr_sources}
\title{Get \emph{all} sources of economic data}
\usage{
fredr_sources(limit = NULL, offset = NULL, order_by = NULL,
  sort_order = NULL, realtime_start = NULL, realtime_end = NULL)
}
\arguments{
\item{limit}{An integer limit on the maximum number of results to return.
Defaults to \code{1000}, the maximum.}

\item{offset}{An integer used in conjunction with limit for long series.
This mimics the idea of \emph{pagination} to retrieve large amounts of data over
multiple calls. Defaults to \code{0}.}

\item{order_by}{A string indicating which attribute should be used to order
the results.  Possible values: \code{"source_id"} (default), \code{"name"},
\code{"realtime_start"}, \code{"realtime_end"}.}

\item{sort_order}{A string representing the order of the resulting series.
Possible values are: \code{"asc"} (default), and \code{"desc"}.}

\item{realtime_start}{A \code{Date} indicating the start of the real-time period.
Defaults to today's date. For more information, see
\href{https://research.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{realtime_end}{A \code{Date} indicating the end of the real-time period.
Defaults to today's date. For more information, see
\href{https://research.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}
}
\value{
A \code{tibble} object.
}
\description{
Get \emph{all} sources of economic data
}
\section{API Documentation}{


\href{https://research.stlouisfed.org/docs/api/fred/sources.html}{fred/sources}
}

\examples{
\donttest{
fredr_sources(limit = 20L)
}
}
\seealso{
\code{\link[=fredr_source]{fredr_source()}}, \code{\link[=fredr_source_releases]{fredr_source_releases()}}
}
