% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_releases_dates.R
\name{fredr_releases_dates}
\alias{fredr_releases_dates}
\title{Get release dates for \emph{all} releases of economic data.}
\usage{
fredr_releases_dates(
  ...,
  limit = NULL,
  offset = NULL,
  sort_order = NULL,
  order_by = NULL,
  include_release_dates_with_no_data = NULL,
  realtime_start = NULL,
  realtime_end = NULL
)
}
\arguments{
\item{...}{These dots only exist for future extensions and should be empty.}

\item{limit}{An integer limit on the maximum number of results to return.
Defaults to \code{1000}, the maximum.}

\item{offset}{An integer used in conjunction with \code{limit} for long series.
This mimics the idea of \emph{pagination} to retrieve large amounts of data over
multiple calls. Defaults to \code{0}.}

\item{sort_order}{A string representing the order of the resulting series.
Possible values are: \code{"asc"} and \code{"desc"} (default).}

\item{order_by}{Order results by values of the specified attribute.
Possible values include: \code{'release_date'} (default), \code{'release_id'},
\code{'release_name'}.}

\item{include_release_dates_with_no_data}{A boolean value indicating if the
results with no data available should be returned as well.  Default is \code{FALSE}.}

\item{realtime_start}{A \code{Date} indicating the start of the real-time period.
Defaults to the first day of the current year. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{realtime_end}{A \code{Date} indicating the end of the real-time period.
Defaults to \code{9999-12-31} (latest available). For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}
}
\value{
A \code{tibble} object.
}
\description{
Get release dates for \emph{all} releases of economic data. Note that release
dates are published by data sources and do not necessarily represent when
data will be available on the FRED or ALFRED websites.
}
\section{API Documentation}{


\href{https://fred.stlouisfed.org/docs/api/fred/releases_dates.html}{fred/releases/dates}
}

\examples{
if (fredr_has_key()) {
fredr_releases_dates(limit = 20L)
}
}
\seealso{
\code{\link[=fredr_releases]{fredr_releases()}}, \code{\link[=fredr_release_dates]{fredr_release_dates()}}, \code{\link[=fredr_release]{fredr_release()}},
\code{\link[=fredr_release_series]{fredr_release_series()}}, \code{\link[=fredr_release_sources]{fredr_release_sources()}}, \code{\link[=fredr_release_tags]{fredr_release_tags()}},
\code{\link[=fredr_release_related_tags]{fredr_release_related_tags()}}, \code{\link[=fredr_release_tables]{fredr_release_tables()}}
}
