% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_source.R
\name{fredr_source}
\alias{fredr_source}
\title{Get a source of economic data}
\usage{
fredr_source(source_id, ..., realtime_start = NULL, realtime_end = NULL)
}
\arguments{
\item{source_id}{An integer ID for the data source.}

\item{...}{These dots only exist for future extensions and should be empty.}

\item{realtime_start}{A \code{Date} indicating the start of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{realtime_end}{A \code{Date} indicating the end of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}
}
\value{
A \code{tibble} object.
}
\description{
Get a source of economic data
}
\section{API Documentation}{


\href{https://fred.stlouisfed.org/docs/api/fred/source.html}{fred/source}
}

\examples{
if (fredr_has_key()) {
fredr_source(source_id = 14L)

# Has this source ID ever changed over time?
fredr_source(source_id = 14L, realtime_start = as.Date("1990-01-01"))
}
}
\seealso{
\code{\link[=fredr_sources]{fredr_sources()}}, \code{\link[=fredr_source_releases]{fredr_source_releases()}}
}
