library(freedom)
df <- sample_data(nherds = 50,
                 mean_herd_size = 500,
                 n_herd_urg = 2,
                 herd_dist = c(0.8,0.2),
                 herd_samp_frac = 0.15,
                 herd_samp_dist = c(0.1, 0.9),
                 n_animal_urg = 2,
                 animal_dist = c(0.1, 0.9),
                 animal_samp_frac = 0.15,
                 animal_samp_dist = c(0.9, 0.1),
                 seed = 1)

stopifnot(identical(df, structure(list(ppn = c(1L, 1L, 2L, 2L, 3L, 3L, 4L, 4L, 5L, 5L, 
6L, 6L, 8L, 8L, 9L, 9L, 10L, 10L, 11L, 11L, 12L, 12L, 13L, 13L, 
15L, 15L, 17L, 17L, 18L, 18L, 19L, 19L, 20L, 20L, 21L, 21L, 22L, 
22L, 23L, 23L, 25L, 25L, 26L, 26L, 27L, 27L, 28L, 28L, 29L, 29L, 
30L, 30L, 31L, 31L, 32L, 32L, 33L, 33L, 34L, 34L, 35L, 35L, 36L, 
36L, 37L, 37L, 38L, 38L, 39L, 39L, 40L, 40L, 41L, 41L, 42L, 42L, 
43L, 43L, 44L, 44L, 45L, 45L, 46L, 46L, 48L, 48L, 49L, 49L, 50L, 
50L, 7L, 7L, 14L, 14L, 16L, 16L, 24L, 24L, 47L, 47L), herd_urg = structure(c(1L, 
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 
2L, 2L, 2L), .Label = c("1", "2"), class = "factor"), animal_urg = c(1L, 
2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 
2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 
2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 
2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 
2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 
2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 
2L, 1L, 2L), N_animal_urg = c(59L, 426L, 55L, 474L, 56L, 472L, 
46L, 463L, 49L, 416L, 53L, 457L, 61L, 451L, 57L, 436L, 52L, 430L, 
48L, 438L, 52L, 441L, 61L, 437L, 46L, 475L, 61L, 452L, 46L, 474L, 
47L, 470L, 53L, 448L, 54L, 401L, 45L, 466L, 57L, 467L, 45L, 444L, 
62L, 432L, 55L, 442L, 43L, 442L, 55L, 414L, 52L, 470L, 43L, 447L, 
39L, 485L, 52L, 465L, 73L, 423L, 44L, 445L, 48L, 464L, 42L, 442L, 
43L, 422L, 53L, 464L, 60L, 437L, 55L, 450L, 54L, 437L, 42L, 465L, 
41L, 433L, 48L, 457L, 53L, 460L, 49L, 463L, 48L, 448L, 53L, 446L, 
58L, 458L, 51L, 448L, 58L, 460L, 39L, 445L, 54L, 442L), n_animal_urg = c(0L, 
0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 61L, 7L, 0L, 0L, 
0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 61L, 8L, 0L, 0L, 0L, 
0L, 0L, 0L, 0L, 0L, 0L, 0L, 57L, 6L, 0L, 0L, 0L, 0L, 0L, 0L, 
0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 
0L, 0L, 42L, 7L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 54L, 9L, 0L, 
0L, 41L, 6L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 53L, 10L, 58L, 12L, 
51L, 5L, 58L, 2L, 39L, 10L, 37L, 2L)), .Names = c("ppn", "herd_urg", 
"animal_urg", "N_animal_urg", "n_animal_urg"), row.names = c("1", 
"2", "210", "21", "3", "31", "4", "41", "5", "51", "6", "61", 
"8", "81", "9", "91", "10", "101", "11", "111", "12", "121", 
"13", "131", "15", "151", "17", "171", "18", "181", "19", "191", 
"20", "201", "212", "211", "22", "221", "23", "231", "25", "251", 
"26", "261", "27", "271", "28", "281", "29", "291", "30", "301", 
"312", "311", "32", "321", "33", "331", "34", "341", "35", "351", 
"36", "361", "37", "371", "38", "381", "39", "391", "40", "401", 
"412", "411", "42", "421", "43", "431", "44", "441", "45", "451", 
"46", "461", "48", "481", "49", "491", "50", "501", "7", "71", 
"14", "141", "16", "161", "24", "241", "47", "471"), class = "data.frame")))

df <- sample_data(nherds = 10,
                 mean_herd_size = 500,
                 n_herd_urg = 2,
                 herd_dist = c(0.8,0.2),
                 herd_samp_frac = 0.15,
                 herd_samp_dist = c(0.1, 0.9),
                 n_animal_urg = 1,
                 animal_dist = c(1),
                 animal_samp_frac = 0.15,
                 animal_samp_dist = c(1),
                 seed = 2)

stopifnot(identical(df, structure(list(ppn = c(2L, 3L, 4L, 6L, 8L, 10L, 1L, 5L, 7L, 9L
), herd_urg = structure(c(1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 
2L), .Label = c("1", "2"), class = "factor"), animal_urg = c(1L, 
1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), N_animal_urg = c(478L, 474L, 
502L, 494L, 509L, 491L, 479L, 484L, 483L, 521L), n_animal_urg = c(0L, 
0L, 0L, 0L, 0L, 0L, 62L, 87L, 111L, 93L)), .Names = c("ppn", 
"herd_urg", "animal_urg", "N_animal_urg", "n_animal_urg"), row.names = c(2L, 
3L, 4L, 6L, 8L, 10L, 1L, 5L, 7L, 9L), class = "data.frame")))

df <- sample_data(nherds = 10,
                 mean_herd_size = 500,
                 n_herd_urg = 4,
                 herd_dist = c(0.1,0.2,0.6,0.1),
                 herd_samp_frac = 1,
                 herd_samp_dist = c(0.1, 0.8, 0.05, 0.05),
                 n_animal_urg = 4,
                 animal_dist = c(0.05, 0.05,0.1, 0.8),
                 animal_samp_frac = 0.15,
                 animal_samp_dist = c(0.8,0.05,0.05,0.1),
                 seed = 1)

stopifnot(identical(df, structure(list(ppn = c(3L, 3L, 3L, 3L, 4L, 4L, 4L, 4L, 1L, 1L, 
1L, 1L, 2L, 2L, 2L, 2L, 5L, 5L, 5L, 5L, 7L, 7L, 7L, 7L, 8L, 8L, 
8L, 8L, 9L, 9L, 9L, 9L, 10L, 10L, 10L, 10L, 6L, 6L, 6L, 6L), 
    herd_urg = structure(c(2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 3L, 
    3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 
    3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 4L, 4L, 4L, 
    4L), .Label = c("1", "2", "3", "4"), class = "factor"), animal_urg = c(1L, 
    2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 
    1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 
    4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L), N_animal_urg = c(31L, 
    27L, 47L, 423L, 23L, 32L, 45L, 409L, 25L, 24L, 62L, 374L, 
    31L, 16L, 47L, 435L, 25L, 24L, 48L, 368L, 27L, 29L, 51L, 
    409L, 30L, 29L, 64L, 389L, 32L, 22L, 47L, 392L, 26L, 28L, 
    52L, 376L, 24L, 29L, 58L, 399L), n_animal_urg = c(31L, 3L, 
    6L, 8L, 23L, 5L, 5L, 5L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 
    0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 
    0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L)), .Names = c("ppn", "herd_urg", 
"animal_urg", "N_animal_urg", "n_animal_urg"), row.names = c("3", 
"31", "32", "33", "4", "41", "42", "43", "1", "2", "34", "44", 
"24", "21", "22", "23", "5", "51", "52", "53", "7", "71", "72", 
"73", "8", "81", "82", "83", "9", "91", "92", "93", "10", "101", 
"102", "103", "6", "61", "62", "63"), class = "data.frame")))
