% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nii2mnc.R
\name{nii2mnc}
\alias{nii2mnc}
\title{Convert NIfTI to MNC}
\usage{
nii2mnc(file, outfile = NULL)
}
\arguments{
\item{file}{(character) input filename}

\item{outfile}{(character) output filename}
}
\value{
Character filename of output
}
\description{
This function calls \code{nii2mnc} 
to convert NIfTI to MNC files
}
\examples{
if (have_fs() && requireNamespace("oro.nifti", quietly = TRUE)) {
   img = oro.nifti::nifti(array(rnorm(5*5*5), dim = c(5,5,5)))  
   mnc = nii2mnc(img)
   img_file = mnc2nii(mnc)
}
}
