% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fs_annot.R
\name{colortable.from.annot}
\alias{colortable.from.annot}
\title{Extract color lookup table (LUT) from annotation.}
\usage{
colortable.from.annot(annot, compute_colorcode = FALSE)
}
\arguments{
\item{annot}{An annotation, as returned by \code{\link[freesurferformats]{read.fs.annot}}. If you want to assign specific indices, you can add a column named 'struct_index' to the data.frame \code{annot$colortable_df}. If there is no such columns, the indices will be created automatically in the order of the regions, starting at zero.}

\item{compute_colorcode}{logical, indicates whether the unique color codes should be computed and added to the returned data.frame as an extra integer column named 'code'. Defaults to FALSE.}
}
\value{
the colortable data.frame extracted from the annotation.
}
\description{
Extract a colortable lookup table (LUT) from an annotation. Such a LUT can also be read from files like `FREESURFER_HOME/FreeSurferColorLUT.txt` or saved as a file, check the 'See Also' section below.
}
\examples{
    annotfile = system.file("extdata", "lh.aparc.annot.gz",
     package = "freesurferformats", mustWork = TRUE);
    annot = read.fs.annot(annotfile);
    colortable = colortable.from.annot(annot);
    head(colortable);

}
\seealso{
Other atlas functions: 
\code{\link{read.fs.annot}()},
\code{\link{read.fs.colortable}()},
\code{\link{write.fs.annot}()},
\code{\link{write.fs.colortable}()}

Other colorLUT functions: 
\code{\link{read.fs.colortable}()},
\code{\link{write.fs.colortable}()}
}
\concept{atlas functions}
\concept{colorLUT functions}
