% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgh2nii.R
\name{fs.volume.from.oro.nifti}
\alias{fs.volume.from.oro.nifti}
\title{Turn an `oro.nifti` instance into an `fs.volume` instance with complete header.}
\usage{
fs.volume.from.oro.nifti(nifti_img)
}
\arguments{
\item{nifti_img}{instance of class `nifti` from the `oro.nifti` package}
}
\value{
an `fs.volume` instance. The `header` fields are computed from the NIFTI header. The `data` array is rotated into FreeSurfer storage order, but otherwise returned as present in the input NIFTI instance, i.e., no values are changed in any way.
}
\description{
This is work in progress. This function takes an `oro.nifti` instance and computes the MGH header fields from the NIFTI header data, allowing for proper orientation of the contained image data (see \code{\link[freesurferformats]{mghheader.vox2ras}} and related functions). Currently only few datatypes are supported, and the `sform` header field needs to be present in the NIFTI instance.
}
\examples{
\dontrun{
   nii_file = "~/data/tim_only/tim/mri/brain.nii";  # mri_convert brain.mgz brain.nii
   nii_img = oro.nifti::readNIfTI(nii_file);
   fsvolume = fs.volume.from.oro.nifti(nii_img);
}

}
\references{
\href{https://nifti.nimh.nih.gov/nifti-1/}{NIfTI-1 data format spec}
}
\seealso{
\code{\link[oro.nifti]{readNIfTI}}, \code{\link[freesurferformats]{read.fs.mgh}}
}
\keyword{internal}
