% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bootstrap.R
\name{bs_vars_dropdown}
\alias{bs_vars_dropdown}
\title{Bootstrap dropdown variables}
\usage{
bs_vars_dropdown(
  bg = NULL,
  border = NULL,
  fallback_border = NULL,
  divider_bg = NULL,
  link_color = NULL,
  link_hover_color = NULL,
  link_hover_bg = NULL,
  link_active_color = NULL,
  link_active_bg = NULL,
  link_disabled_color = NULL,
  header_color = NULL
)
}
\arguments{
\item{bg}{Background color for the dropdown menu.}

\item{border}{Dropdown menu border-color.}

\item{fallback_border}{Dropdown menu border-color (for IE8).}

\item{divider_bg}{Divider color for between dropdown items.}

\item{link_color}{Dropdown link text color.}

\item{link_hover_color}{Hover color for dropdown links.}

\item{link_hover_bg}{Hover background for dropdown links.}

\item{link_active_color}{Active dropdown menu item text color.}

\item{link_active_bg}{Active dropdown menu item background color.}

\item{link_disabled_color}{Disabled dropdown menu item background color.}

\item{header_color}{Text color for headers within dropdown menus.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
Those variables can be used to customize
 dropdowns (e.g. \code{\link[shinyWidgets:dropdownButton]{shinyWidgets::dropdownButton}}
 in Bootstrap and Bootswatch themes.
}
\examples{
bs_vars_dropdown(
  bg = "#FAFAFA",
  border = "firebrick"
)

if (interactive()) {
  library(shiny)
  library(shinyWidgets)

  ui <- fluidPage(
    use_theme(
      create_theme(
        theme = "default",
        bs_vars_dropdown(
          bg = "#FAFAFA",
          border = "firebrick"
        ),
        output_file = NULL
      )
    ),
    tags$h1("Custom dropdowns"),
    dropdownButton(
      inputId = "mydropdown",
      label = "Controls",
      icon = icon("sliders"),
      status = "primary",
      circle = FALSE,
      sliderInput(
        inputId = "n",
        label = "Number of observations",
        min = 10, max = 100, value = 30
      ),
      prettyToggle(
        inputId = "na",
        label_on = "NAs keeped",
        label_off = "NAs removed",
        icon_on = icon("check"),
        icon_off = icon("remove")
      )
    )
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
