% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_helpers.R
\name{get_boolean_envvar}
\alias{get_boolean_envvar}
\title{Get a Boolean Environment Variable}
\usage{
get_boolean_envvar(x, stop_on_failure = FALSE)
}
\arguments{
\item{x}{The name of the Environment Variable.}

\item{stop_on_failure}{Throw an error instead of returning
\code{\link{FALSE}} if the environment variable is not set or cannot be
converted to boolean.}
}
\value{
The value the environment variable is set to, converted to boolean.
\code{\link{FALSE}} if the environment variable is not set or cannot be
converted to boolean.
}
\description{
A convenience wrapper to \code{\link{Sys.getenv}}.
}
\details{
As \code{\link{Sys.getenv}} seems to always return a character vector, the
\code{\link{class}} of the value you set it to does not matter.
}
\examples{
message("See\n example(\"get_run_r_tests\", package = \"fritools\")")
}
\seealso{
Other test helpers: 
\code{\link{get_run_r_tests}()},
\code{\link{is_running_on_fvafrcu_machines}()},
\code{\link{is_running_on_gitlab_com}()},
\code{\link{run_r_tests_for_known_hosts}()},
\code{\link{set_run_r_tests}()}
}
\concept{test helpers}
