% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_code_file.R
\name{split_code_file}
\alias{split_code_file}
\title{Split a Code File Into Multiple Files}
\usage{
split_code_file(
  file,
  output_directory = tempdir(),
  encoding = getOption("encoding"),
  write_to_disk = getOption("write_to_disk")
)
}
\arguments{
\item{file}{The code file to be split.}

\item{output_directory}{Where to create the new files.}

\item{encoding}{The encoding passed to \code{\link{source}}.}

\item{write_to_disk}{Set the output_directory to
\code{dirname(file)}? Just a shortcut.}
}
\value{
\code{\link[base:invisible]{Invisibly}} a vector of paths to the new
files.
}
\description{
I tend to find files with dozens of functions. They don't read well.
So I split a code file into multiple files each containing a single function.
}
\examples{
infile <- system.file("files", "test_helpers.R", package = "fritools")
\dontrun{
   file.show(infile)
}
paths <- split_code_file(file = infile)
\dontrun{
   file.show(paths[2])
}
}
\seealso{
Other file utilities: 
\code{\link{clipboard_path}()},
\code{\link{delete_trailing_whitespace}()},
\code{\link{develop_test}()},
\code{\link{file_copy}()},
\code{\link{file_modified_last}()},
\code{\link{file_save}()},
\code{\link{find_files}()},
\code{\link{get_mtime}()},
\code{\link{get_unique_string}()},
\code{\link{is_files_current}()},
\code{\link{is_path}()},
\code{\link{paths}},
\code{\link{search_files}()},
\code{\link{touch}()}
}
\concept{file utilities}
