% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_copy.R
\name{file_copy}
\alias{file_copy}
\title{Force Copying a File While backing it up}
\usage{
file_copy(from, to, stop_on_error = FALSE, ...)
}
\arguments{
\item{from}{See \code{\link{file.copy}}.}

\item{to}{See \code{\link{file.copy}}.}

\item{stop_on_error}{Throw an exception on error?}

\item{...}{Arguments passed to \code{\link{file.copy}}.}
}
\value{
A vector of  \code{\link[base:TRUE]{boolean}} values indicating
success or failure.
}
\description{
\code{\link{file.copy}} has an argument \code{overwrite} that allows for
overwriting existing files. But I often want to overwrite an existing file
while creating a backup copy of that file.
}
\examples{
touch(f1 <- file.path(tempdir(), "first.R"),
      f2 <- file.path(tempdir(), "second.R"))
dir.create(t <- file.path(tempdir(), "foo"))
file_copy(from = c(f2, f1), to = t)
dir(t)
touch(f1)
touch(f2)
file_copy(from = c(f2, f1), to = t)
dir(t)
list.files(tempdir(), pattern = "first.*\\\\.R")
dir <- file.path(tempdir(), "subdir")
dir.create(dir)
file_copy(f1, dir)
touch(f1)
file_copy(f1, dir)
list.files(dir, pattern = "first.*\\\\.R")
}
\seealso{
Other file utilities: 
\code{\link{clipboard_path}()},
\code{\link{delete_trailing_whitespace}()},
\code{\link{develop_test}()},
\code{\link{file_modified_last}()},
\code{\link{file_save}()},
\code{\link{find_files}()},
\code{\link{get_mtime}()},
\code{\link{get_unique_string}()},
\code{\link{is_files_current}()},
\code{\link{is_path}()},
\code{\link{paths}},
\code{\link{search_files}()},
\code{\link{split_code_file}()},
\code{\link{touch}()}

Other operating system functions: 
\code{\link{clipboard_path}()},
\code{\link{file_save}()},
\code{\link{get_boolean_envvar}()},
\code{\link{get_run_r_tests}()},
\code{\link{is_installed}()},
\code{\link{is_r_package_installed}()},
\code{\link{is_success}()},
\code{\link{is_windows}()},
\code{\link{view}()},
\code{\link{vim}()},
\code{\link{wipe_tempdir}()},
\code{\link{with_dir}()}
}
\concept{file utilities}
\concept{operating system functions}
