% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_lines_between_tags.R
\name{get_lines_between_tags}
\alias{get_lines_between_tags}
\title{Cut Code Chunks From a File}
\usage{
get_lines_between_tags(
  file_name,
  keep_tagged_lines = TRUE,
  begin_pattern = "ROXYGEN_START",
  end_pattern = "ROXYGEN_STOP",
  from_first_line = TRUE,
  to_last_line = TRUE
)
}
\arguments{
\item{file_name}{The name of the R code file to be parsed.}

\item{keep_tagged_lines}{Keep tagged lines output?}

\item{begin_pattern}{A pattern that marks the line beginning a
\pkg{roxygen2}
chunk.}

\item{end_pattern}{A pattern that marks the line ending a \pkg{roxygen2}
chunk.}

\item{from_first_line}{Use first line as tagged line if first tag found
matches the \code{end_pattern}?}

\item{to_last_line}{Use last line as tagged line if last tag found matches
the \code{begin_pattern}?}
}
\value{
A character vector of matching lines.
}
\description{
Get all lines between tagged lines. The tagged lines themselves may be in- or
excluded from the selection.
}
\note{
If you know the file to contain valid \pkg{roxygen2} code only, you do
not
need to tag any lines if you keep from_first_line and to_last_line both TRUE:
in this case the whole file will be returned.
}
\seealso{
Other file utilities: 
\code{\link{clipboard_path}()},
\code{\link{delete_trailing_blank_lines}()},
\code{\link{delete_trailing_whitespace}()},
\code{\link{develop_test}()},
\code{\link{file_copy}()},
\code{\link{file_modified_last}()},
\code{\link{file_save}()},
\code{\link{find_files}()},
\code{\link{get_mtime}()},
\code{\link{get_unique_string}()},
\code{\link{grep_file}()},
\code{\link{is_files_current}()},
\code{\link{is_path}()},
\code{\link{paths}},
\code{\link{runsed}()},
\code{\link{search_files}()},
\code{\link{split_code_file}()},
\code{\link{touch}()}
}
\concept{file utilities}
