% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{coloredmesh.from.morph.native}
\alias{coloredmesh.from.morph.native}
\title{Create a coloredmesh from native space morphometry data.}
\usage{
coloredmesh.from.morph.native(subjects_dir, subject_id, measure, hemi,
  surface = "white", colormap = squash::jet)
}
\arguments{
\item{subjects_dir, }{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id, }{string. The subject identifier.}

\item{measure, }{string. The morphometry data to use. E.g., 'area' or 'thickness.'}

\item{hemi, }{string, one of 'lh' or 'rh'. The hemisphere name. Used to construct the names of the label data files to be loaded.}

\item{surface, }{string. The display surface. E.g., "white", "pial", or "inflated". Defaults to "white".}

\item{colormap, }{a colormap. See the squash package for some colormaps. Defaults to squash::jet.}
}
\value{
coloredmesh. A named list with entries: "mesh" the rgl::tmesh3d mesh object. "col": the mesh colors. "morph_data_was_all_na", logical. Whether the mesh values were all NA, and thus replaced by the all_nan_backup_value. "hemi": the hemisphere, one of 'lh' or 'rh'.
}
\description{
Create a coloredmesh from native space morphometry data.
}
\keyword{internal}
