% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morph_agg.R
\name{group.morph.agg.standard}
\alias{group.morph.agg.standard}
\title{Aggregate standard space (fsaverage) morphometry data over one hemisphere for a group of subjects.}
\usage{
group.morph.agg.standard(subjects_dir, subjects_list, measure, hemi, fwhm,
  agg_fun = mean, template_subject = "fsaverage", format = "mgh",
  cast = TRUE)
}
\arguments{
\item{subjects_dir, }{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subjects_list, }{string vector. A vector of subject identifiers that match the directory names within subjects_dir.}

\item{measure, }{string. Name of the vertex-wise measure of morphometry data file. E.g., "area" or "thickness". Used to construct the name of the morphometry file to be loaded.}

\item{hemi, }{string, one of 'lh', 'rh' or 'both'. The hemisphere name. Used to construct the names of the annotation and morphometry data files to be loaded.}

\item{fwhm, }{string. Smoothing as string, e.g. '10' or '25'.}

\item{agg_fun, }{function. An R function that aggregates data, typically max, mean, min or something similar. Note: this is NOT a string, put the function name without quotes. Defaults to mean.}

\item{template_subject, }{string. Template subject name, defaults to 'fsaverage'.}

\item{format, }{string. One of 'mgh', 'mgz', 'curv'. Defaults to 'mgh'.}

\item{cast, }{logical. Whether the columns should be database style, i.e., separate columns for everything.}
}
\value{
dataframe with aggregated values for all subjects, with 2 columns and n rows, where n is the number of subjects. The 2 columns are 'subject_id' and '<hemi>.<measure>' (e.g., "lh.thickness"), the latter contains the aggregated data.
}
\description{
Compute the mean (or other aggregates) over all vertices of a subject from standard space morphometry data (like 'surf/lh.area.fwhm10.fsaverage.mgh'). Uses knowledge about the FreeSurfer directory structure to load the correct file.
}
\seealso{
Other global aggregation functions: \code{\link{group.morph.agg.native}},
  \code{\link{group.multimorph.agg.native}},
  \code{\link{group.multimorph.agg.standard}}
}
\concept{global aggregation functions}
