% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{highlight.vertices.on.subject}
\alias{highlight.vertices.on.subject}
\title{Highlight vertices given by index on a subject's meshes.}
\usage{
highlight.vertices.on.subject(
  subjects_dir,
  vis_subject_id,
  verts_lh = NULL,
  verts_rh = NULL,
  surface = "white",
  views = c("t4"),
  rgloptions = rglo(),
  rglactions = list(),
  color_bg = "#FEFEFE",
  color_verts_lh = "#FF0000",
  color_verts_rh = "#FF4500",
  k = 3L
)
}
\arguments{
\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{vis_subject_id}{string. The subject identifier from which to obtain the surface for data visualization. Example: 'fsaverage'.}

\item{verts_lh}{integer vector, the indices of left hemisphere vertices.}

\item{verts_rh}{integer vector, the indices of right hemisphere vertices.}

\item{surface}{string. The display surface. E.g., "white", "pial", or "inflated". Defaults to "white".}

\item{views}{list of strings. Valid entries include: 'si': single interactive view. 't4': tiled view showing the brain from 4 angles. 't9': tiled view showing the brain from 9 angles.}

\item{rgloptions}{option list passed to \code{\link{par3d}}. Example: \code{rgloptions = list("windowRect"=c(50,50,1000,1000))}.}

\item{rglactions}{named list. A list in which the names are from a set of pre-defined actions. The values can be used to specify parameters for the action. The following example clips outliers in the data before plotting and writes a screenshot in PNG format: \code{rglactions = list("snapshot_png"="~/fsbrain.png", "clip_data"=c(0.05, 0.95))}. See \code{\link{rglactions}}.}

\item{color_bg}{Background color.}

\item{color_verts_lh}{vector of colors to visualize on the left hemisphere surface. Length must match number of vertices in 'verts_lh', or be a single color.}

\item{color_verts_rh}{vector of colors to visualize on the right hemisphere surface. Length must match number of vertices in 'verts_rh', or be a single color.}

\item{k}{integer, radius to extend neighborhood (for better visibility).}
}
\value{
list of coloredmeshes. The coloredmeshes used for the visualization.
}
\description{
Highlight vertices given by index on a subject's meshes.
}
\seealso{
Other visualization functions: 
\code{\link{vis.color.on.subject}()},
\code{\link{vis.data.on.fsaverage}()},
\code{\link{vis.data.on.subject}()},
\code{\link{vis.labeldata.on.subject}()},
\code{\link{vis.mask.on.subject}()},
\code{\link{vis.region.values.on.subject}()},
\code{\link{vis.subject.annot}()},
\code{\link{vis.subject.label}()},
\code{\link{vis.subject.morph.native}()},
\code{\link{vis.subject.morph.standard}()},
\code{\link{vis.symmetric.data.on.subject}()},
\code{\link{vislayout.from.coloredmeshes}()}

Other surface visualization functions: 
\code{\link{vis.color.on.subject}()}
}
\concept{surface visualization functions}
\concept{visualization functions}
